/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.codec;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.broker.network.codec.BrokerPayloadCodec;
import org.joyqueue.broker.network.command.GetPartitionGroupClusterRequest;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Type;

public class GetPartitionGroupClusterRequestCodec
implements Type,
BrokerPayloadCodec<GetPartitionGroupClusterRequest> {
    public Object decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        GetPartitionGroupClusterRequest request = new GetPartitionGroupClusterRequest();
        HashMap groups = Maps.newHashMap();
        int topicSize = buffer.readInt();
        for (int i = 0; i < topicSize; ++i) {
            String topic = Serializer.readString((ByteBuf)buffer);
            int partitionGroupSize = buffer.readInt();
            ArrayList partitionGroups = Lists.newArrayListWithCapacity((int)partitionGroupSize);
            for (int j = 0; j < partitionGroupSize; ++j) {
                int group = buffer.readInt();
                partitionGroups.add(group);
            }
            groups.put(topic, partitionGroups);
        }
        request.setGroups(groups);
        return request;
    }

    public void encode(GetPartitionGroupClusterRequest payload, ByteBuf buffer) throws Exception {
        buffer.writeInt(payload.getGroups().size());
        for (Map.Entry<String, List<Integer>> entry : payload.getGroups().entrySet()) {
            Serializer.write((String)entry.getKey(), (ByteBuf)buffer);
            buffer.writeInt(entry.getValue().size());
            for (Integer partitionGroup : entry.getValue()) {
                buffer.writeInt(partitionGroup.intValue());
            }
        }
    }

    public int type() {
        return 72;
    }
}

