/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.joyqueue.network.transport.command.JoyQueuePayload;

public class GetPartitionGroupClusterResponse
extends JoyQueuePayload {
    private Map<String, Map<Integer, PartitionGroupCluster>> groups;

    public void setGroups(Map<String, Map<Integer, PartitionGroupCluster>> groups) {
        this.groups = groups;
    }

    public Map<String, Map<Integer, PartitionGroupCluster>> getGroups() {
        return this.groups;
    }

    public PartitionGroupCluster getCluster(String topic, int group) {
        if (this.groups == null) {
            return null;
        }
        Map<Integer, PartitionGroupCluster> topicMap = this.groups.get(topic);
        if (topicMap == null) {
            return null;
        }
        return topicMap.get(group);
    }

    public void addCluster(String topic, int group, PartitionGroupCluster cluster) {
        HashMap topicMap;
        if (this.groups == null) {
            this.groups = Maps.newHashMap();
        }
        if ((topicMap = this.groups.get(topic)) == null) {
            topicMap = Maps.newHashMap();
            this.groups.put(topic, topicMap);
        }
        topicMap.put(group, cluster);
    }

    public int type() {
        return -72;
    }

    public static class PartitionGroupNode {
        private int id;
        private boolean writable;
        private boolean readable;

        public PartitionGroupNode() {
        }

        public PartitionGroupNode(int id, boolean writable, boolean readable) {
            this.id = id;
            this.writable = writable;
            this.readable = readable;
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public void setWritable(boolean writable) {
            this.writable = writable;
        }

        public boolean isReadable() {
            return this.readable;
        }

        public void setReadable(boolean readable) {
            this.readable = readable;
        }
    }

    public static class PartitionGroupCluster {
        private List<PartitionGroupNode> nodes;

        public void addNode(PartitionGroupNode node) {
            if (this.nodes == null) {
                this.nodes = Lists.newLinkedList();
            }
            this.nodes.add(node);
        }

        public PartitionGroupNode getRWNode() {
            for (PartitionGroupNode node : this.nodes) {
                if (!node.isWritable() || !node.isReadable()) continue;
                return node;
            }
            return null;
        }

        public PartitionGroupNode getWritableNode() {
            for (PartitionGroupNode node : this.nodes) {
                if (!node.isWritable()) continue;
                return node;
            }
            return null;
        }

        public List<PartitionGroupNode> getReadableNodes() {
            ArrayList result = Lists.newArrayListWithCapacity((int)this.nodes.size());
            for (PartitionGroupNode node : this.nodes) {
                if (!node.isReadable()) continue;
                result.add(node);
            }
            return result;
        }

        public List<PartitionGroupNode> getNodes() {
            return this.nodes;
        }

        public void setNodes(List<PartitionGroupNode> nodes) {
            this.nodes = nodes;
        }
    }
}

