/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.frontend;

import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.network.backend.BrokerExceptionHandler;
import org.joyqueue.broker.network.protocol.MultiProtocolTransportServerFactory;
import org.joyqueue.broker.network.protocol.ProtocolManager;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.transport.TransportServer;
import org.joyqueue.network.transport.TransportServerFactory;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrontendServer
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(FrontendServer.class);
    private ServerConfig config;
    private BrokerContext brokerContext;
    private ProtocolManager protocolManager;
    private EventBus<TransportEvent> transportEventBus;
    private ExceptionHandler exceptionHandler;
    private TransportServerFactory transportServerFactory;
    private TransportServer transportServer;

    public FrontendServer(ServerConfig config, BrokerContext brokerContext, ProtocolManager protocolManager) {
        this.config = config;
        this.brokerContext = brokerContext;
        this.protocolManager = protocolManager;
        this.transportEventBus = new EventBus("joyqueue-frontend-eventBus");
        this.exceptionHandler = new BrokerExceptionHandler();
        this.transportServerFactory = new MultiProtocolTransportServerFactory(protocolManager, brokerContext, this.transportEventBus, this.exceptionHandler);
    }

    public void addListener(EventListener<TransportEvent> listener) {
        this.transportEventBus.addListener(listener);
    }

    public void removeListener(EventListener<TransportEvent> listener) {
        this.transportEventBus.removeListener(listener);
    }

    protected void doStart() throws Exception {
        this.transportEventBus.start();
        this.transportServer = this.transportServerFactory.bind(this.config, this.config.getHost(), this.config.getPort());
        this.transportServer.start();
        logger.info("frontend server is started, host: {}, port: {}", (Object)this.config.getHost(), (Object)this.config.getPort());
    }

    protected void doStop() {
        this.transportEventBus.stop();
        this.transportServer.stop();
    }
}

