/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.protocol;

import com.google.common.collect.Lists;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.joyqueue.broker.network.protocol.MultiProtocolHandlerPipelineFactory;
import org.joyqueue.broker.network.protocol.ProtocolContext;
import org.joyqueue.broker.network.protocol.ProtocolHandlerPipelineFactory;
import org.joyqueue.broker.network.protocol.ProtocolManager;
import org.joyqueue.network.protocol.Protocol;
import org.joyqueue.network.protocol.ProtocolServer;
import org.joyqueue.network.transport.TransportServer;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.network.transport.support.ChannelTransportServer;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiProtocolTransportServer
extends Service
implements TransportServer {
    protected static final Logger logger = LoggerFactory.getLogger(MultiProtocolTransportServer.class);
    private ServerConfig serverConfig;
    private String host;
    private int port;
    private ProtocolManager protocolManager;
    private MultiProtocolHandlerPipelineFactory multiProtocolHandlerPipelineFactory;
    private ProtocolHandlerPipelineFactory protocolHandlerPipelineFactory;
    private TransportServer protocolServiceServer;
    private List<ProtocolContext> protocolServers;

    public MultiProtocolTransportServer(ServerConfig serverConfig, String host, int port, ProtocolManager protocolManager, MultiProtocolHandlerPipelineFactory multiProtocolHandlerPipelineFactory, ProtocolHandlerPipelineFactory protocolHandlerPipelineFactory) {
        this.serverConfig = serverConfig;
        this.host = host;
        this.port = port;
        this.protocolManager = protocolManager;
        this.multiProtocolHandlerPipelineFactory = multiProtocolHandlerPipelineFactory;
        this.protocolHandlerPipelineFactory = protocolHandlerPipelineFactory;
    }

    public InetSocketAddress getSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public boolean isSSLServer() {
        return false;
    }

    protected void validate() throws Exception {
        this.protocolServiceServer = new ChannelTransportServer(this.multiProtocolHandlerPipelineFactory.createPipeline(), this.serverConfig, this.host, this.port);
        this.protocolServers = this.initProtocolServers();
    }

    protected void doStart() throws Exception {
        this.protocolServiceServer.start();
        for (ProtocolContext protocolServer : this.protocolServers) {
            try {
                protocolServer.getTransportServer().start();
                logger.info("protocol {} is start, address: {}", (Object)protocolServer.getProtocol().type(), (Object)protocolServer.getTransportServer().getSocketAddress());
            }
            catch (Exception e) {
                logger.error("protocol {} start failed", (Object)protocolServer.getProtocol().type(), (Object)e);
            }
        }
    }

    protected void doStop() {
        this.protocolServiceServer.stop();
        for (ProtocolContext protocolServer : this.protocolServers) {
            try {
                protocolServer.getTransportServer().stop();
                logger.info("protocol {} is stop", (Object)protocolServer.getProtocol().type(), (Object)protocolServer.getTransportServer().getSocketAddress());
            }
            catch (Exception e) {
                logger.error("protocol {} stop failed", (Object)protocolServer.getProtocol().type(), (Object)e);
            }
        }
    }

    protected List<ProtocolContext> initProtocolServers() {
        ArrayList result = Lists.newArrayList();
        for (ProtocolServer protocolServer : this.protocolManager.getProtocolServers()) {
            ServerConfig protocolServerConfig = protocolServer.createServerConfig(this.serverConfig);
            ChannelTransportServer transportServer = new ChannelTransportServer(this.protocolHandlerPipelineFactory.createPipeline((Protocol)protocolServer), protocolServerConfig, protocolServerConfig.getHost(), protocolServerConfig.getPort());
            result.add(new ProtocolContext((Protocol)protocolServer, (TransportServer)transportServer));
        }
        return result;
    }
}

