/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.protocol;

import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.network.protocol.MultiProtocolHandlerPipelineFactory;
import org.joyqueue.broker.network.protocol.MultiProtocolTransportServer;
import org.joyqueue.broker.network.protocol.ProtocolCommandHandlerFilterFactory;
import org.joyqueue.broker.network.protocol.ProtocolHandlerPipelineFactory;
import org.joyqueue.broker.network.protocol.ProtocolManager;
import org.joyqueue.broker.network.protocol.support.DefaultMultiProtocolHandlerPipelineFactory;
import org.joyqueue.broker.network.protocol.support.DefaultProtocolHandlerPipelineFactory;
import org.joyqueue.network.event.TransportEvent;
import org.joyqueue.network.event.TransportEventHandler;
import org.joyqueue.network.handler.ConnectionHandler;
import org.joyqueue.network.transport.RequestBarrier;
import org.joyqueue.network.transport.TransportServer;
import org.joyqueue.network.transport.TransportServerFactory;
import org.joyqueue.network.transport.command.CommandDispatcherFactory;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.command.handler.filter.CommandHandlerFilterFactory;
import org.joyqueue.network.transport.command.support.DefaultCommandDispatcherFactory;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.network.transport.config.TransportConfig;
import org.joyqueue.toolkit.concurrent.EventBus;

public class MultiProtocolTransportServerFactory
implements TransportServerFactory {
    private TransportConfig transportConfig;
    private EventBus<TransportEvent> transportEventBus;
    private ProtocolManager protocolManager;
    private BrokerContext brokerContext;
    private ExceptionHandler exceptionHandler;
    private RequestBarrier requestBarrier;
    private CommandHandlerFilterFactory commandHandlerFilterFactory;
    private CommandDispatcherFactory commandDispatcherFactory;
    private TransportEventHandler transportEventHandler;
    private ConnectionHandler connectionHandler;
    private MultiProtocolHandlerPipelineFactory multiProtocolHandlerPipelineFactory;
    private ProtocolHandlerPipelineFactory protocolHandlerPipelineFactory;

    public MultiProtocolTransportServerFactory(ProtocolManager protocolManager, BrokerContext brokerContext, EventBus<TransportEvent> transportEventBus, ExceptionHandler exceptionHandler) {
        this.protocolManager = protocolManager;
        this.brokerContext = brokerContext;
        this.transportEventBus = transportEventBus;
        this.exceptionHandler = exceptionHandler;
    }

    public TransportServer bind(ServerConfig serverConfig) {
        return this.bind(serverConfig, serverConfig.getHost(), serverConfig.getPort());
    }

    public TransportServer bind(ServerConfig serverConfig, String host) {
        return this.bind(serverConfig, host, serverConfig.getPort());
    }

    public TransportServer bind(ServerConfig serverConfig, String host, int port) {
        this.transportConfig = serverConfig;
        this.requestBarrier = new RequestBarrier(this.transportConfig);
        this.commandHandlerFilterFactory = new ProtocolCommandHandlerFilterFactory(this.brokerContext);
        this.commandDispatcherFactory = new DefaultCommandDispatcherFactory(this.transportConfig, this.requestBarrier, this.commandHandlerFilterFactory, this.exceptionHandler);
        this.transportEventHandler = new TransportEventHandler(this.requestBarrier, this.transportEventBus);
        this.connectionHandler = new ConnectionHandler();
        this.protocolHandlerPipelineFactory = new DefaultProtocolHandlerPipelineFactory(this.commandDispatcherFactory, this.transportEventHandler, this.connectionHandler);
        this.multiProtocolHandlerPipelineFactory = new DefaultMultiProtocolHandlerPipelineFactory(this.protocolManager, this.protocolHandlerPipelineFactory);
        return new MultiProtocolTransportServer(serverConfig, host, port, this.protocolManager, this.multiProtocolHandlerPipelineFactory, this.protocolHandlerPipelineFactory);
    }
}

