/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.protocol;

import com.google.common.collect.Lists;
import com.jd.laf.extension.ExtensionManager;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.network.protocol.ProtocolRejectedExecutionHandler;
import org.joyqueue.broker.network.protocol.support.ProtocolServerWrapper;
import org.joyqueue.broker.network.protocol.support.ProtocolServiceWrapper;
import org.joyqueue.network.protocol.Protocol;
import org.joyqueue.network.protocol.ProtocolException;
import org.joyqueue.network.protocol.ProtocolServer;
import org.joyqueue.network.protocol.ProtocolService;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolManager
extends Service {
    protected static final Logger logger = LoggerFactory.getLogger(ProtocolManager.class);
    private BrokerContext brokerContext;
    private ExecutorService commonThreadPool;
    private ExecutorService fetchThreadPool;
    private ExecutorService produceThreadPool;
    private List<Protocol> protocols = Lists.newLinkedList();
    private List<ProtocolService> protocolServices = Lists.newLinkedList();
    private List<ProtocolServer> protocolServers = Lists.newLinkedList();

    public ProtocolManager(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
        this.commonThreadPool = new ThreadPoolExecutor(brokerContext.getBrokerConfig().getServerCommonThreads(), brokerContext.getBrokerConfig().getServerCommonThreads(), brokerContext.getBrokerConfig().getServerCommonThreadKeepalive(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(brokerContext.getBrokerConfig().getServerCommonThreadQueueSize()), (ThreadFactory)new NamedThreadFactory("joyqueue-frontend-common-threads"), new ProtocolRejectedExecutionHandler("common"));
        this.fetchThreadPool = new ThreadPoolExecutor(brokerContext.getBrokerConfig().getServerFetchThreads(), brokerContext.getBrokerConfig().getServerFetchThreads(), brokerContext.getBrokerConfig().getServerFetchThreadKeepalive(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(brokerContext.getBrokerConfig().getServerFetchThreadQueueSize()), (ThreadFactory)new NamedThreadFactory("joyqueue-frontend-fetch-threads"), new ProtocolRejectedExecutionHandler("fetch"));
        this.produceThreadPool = new ThreadPoolExecutor(brokerContext.getBrokerConfig().getServerProduceThreads(), brokerContext.getBrokerConfig().getServerProduceThreads(), brokerContext.getBrokerConfig().getServerProduceThreadKeepalive(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(brokerContext.getBrokerConfig().getServerProduceThreadQueueSize()), (ThreadFactory)new NamedThreadFactory("joyqueue-frontend-produce-threads"), new ProtocolRejectedExecutionHandler("produce"));
        this.loadProtocols();
    }

    public List<ProtocolService> getProtocolServices() {
        return this.protocolServices;
    }

    public List<ProtocolServer> getProtocolServers() {
        return this.protocolServers;
    }

    public void register(Protocol protocol) {
        this.protocols.add(protocol);
        if (protocol instanceof ProtocolService) {
            this.protocolServices.add((ProtocolService)protocol);
        } else if (protocol instanceof ProtocolServer) {
            this.protocolServers.add((ProtocolServer)protocol);
        }
    }

    protected void doStart() throws Exception {
        for (Protocol protocol : this.protocols) {
            try {
                this.initProtocol(protocol);
                logger.info("protocol {} is init", (Object)protocol.type());
            }
            catch (Exception e) {
                throw new ProtocolException(String.format("protocol %s init failed", protocol.type()), (Throwable)e);
            }
        }
    }

    protected void doStop() {
        for (Protocol protocol : this.protocols) {
            try {
                this.stopProtocol(protocol);
            }
            catch (Exception e) {
                throw new ProtocolException(String.format("protocol %s stop failed", protocol.type()), (Throwable)e);
            }
        }
        this.commonThreadPool.shutdown();
        this.fetchThreadPool.shutdown();
        this.produceThreadPool.shutdown();
    }

    protected List<Protocol> loadProtocols() {
        LinkedList result = Lists.newLinkedList();
        List<ProtocolService> protocolServices = this.doGetProtocolServices();
        List<ProtocolServer> protocolServers = this.doGetProtocolServers();
        for (ProtocolService protocolService : protocolServices) {
            if (!this.brokerContext.getBrokerConfig().getServerShardedThreads()) {
                protocolService = new ProtocolServiceWrapper(protocolService, this.commonThreadPool, this.fetchThreadPool, this.produceThreadPool);
            }
            this.register((Protocol)protocolService);
            result.add(protocolService);
        }
        for (ProtocolServer protocolServer : protocolServers) {
            if (!this.brokerContext.getBrokerConfig().getServerShardedThreads()) {
                protocolServer = new ProtocolServerWrapper(protocolServer, this.commonThreadPool, this.fetchThreadPool, this.produceThreadPool);
            }
            this.register((Protocol)protocolServer);
            result.add(protocolServer);
        }
        return result;
    }

    protected void initProtocol(Protocol protocol) throws Exception {
        if (protocol instanceof BrokerContextAware) {
            ((BrokerContextAware)protocol).setBrokerContext(this.brokerContext);
        }
        if (protocol instanceof LifeCycle) {
            ((LifeCycle)protocol).start();
        }
    }

    protected void stopProtocol(Protocol protocol) throws Exception {
        if (protocol instanceof LifeCycle) {
            ((LifeCycle)protocol).stop();
        }
    }

    protected List<ProtocolService> doGetProtocolServices() {
        return Lists.newArrayList((Iterable)ExtensionManager.getOrLoadExtensions(ProtocolService.class));
    }

    protected List<ProtocolServer> doGetProtocolServers() {
        return Lists.newArrayList((Iterable)ExtensionManager.getOrLoadExtensions(ProtocolServer.class));
    }
}

