/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.joyqueue.broker.network.protocol.ProtocolContext;
import org.joyqueue.broker.network.protocol.ProtocolManager;
import org.joyqueue.network.protocol.ProtocolService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolResolver
extends ByteToMessageDecoder {
    protected static final Logger logger = LoggerFactory.getLogger(ProtocolResolver.class);
    private ProtocolManager protocolManager;
    private Map<String, ProtocolContext> protocolContextMapper;

    public ProtocolResolver(ProtocolManager protocolManager, Map<String, ProtocolContext> protocolContextMapper) {
        this.protocolManager = protocolManager;
        this.protocolContextMapper = protocolContextMapper;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf buffer, List<Object> out) throws Exception {
        ProtocolContext protocolContext = this.matchProtocol(ctx, buffer);
        if (protocolContext == null) {
            byte[] bytes = new byte[buffer.readableBytes()];
            buffer.readBytes(bytes);
            logger.error("unsupported protocol, ctx: {}, buffer: {}", (Object)ctx, (Object)ArrayUtils.toString((Object)bytes));
            ctx.close();
            return;
        }
        this.bindProtocol(ctx, protocolContext);
        ctx.pipeline().fireChannelRegistered().fireChannelActive();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
    }

    protected void bindProtocol(ChannelHandlerContext ctx, ProtocolContext protocolContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("bind protocol, protocol: {}, ctx: {}", (Object)protocolContext.getProtocol().type(), (Object)ctx);
        }
        ctx.pipeline().addLast(new ChannelHandler[]{protocolContext.getHandlerPipeline()}).remove((ChannelHandler)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ProtocolContext matchProtocol(ChannelHandlerContext ctx, ByteBuf buffer) {
        List<ProtocolService> protocols = this.protocolManager.getProtocolServices();
        int readerIndex = buffer.readerIndex();
        for (ProtocolService protocol : protocols) {
            try {
                if (!protocol.isSupport(buffer)) continue;
                ProtocolContext protocolContext = this.getProtocolContext(protocol);
                return protocolContext;
            }
            catch (Exception e) {
                logger.error("resolve protocol exception, ctx: {}, protocol: {}", new Object[]{ctx, protocol, e});
            }
            finally {
                buffer.readerIndex(readerIndex);
            }
        }
        return null;
    }

    protected ProtocolContext getProtocolContext(ProtocolService protocolService) {
        return this.protocolContextMapper.get(protocolService.type());
    }
}

