/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.protocol.support;

import com.google.common.collect.Maps;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.broker.network.protocol.ProtocolContext;
import org.joyqueue.broker.network.protocol.ProtocolHandlerPipelineFactory;
import org.joyqueue.broker.network.protocol.ProtocolManager;
import org.joyqueue.broker.network.protocol.ProtocolResolver;
import org.joyqueue.network.protocol.Protocol;
import org.joyqueue.network.protocol.ProtocolService;

@ChannelHandler.Sharable
public class DefaultMultiProtocolHandlerPipeline
extends ChannelInitializer {
    private ProtocolManager protocolManager;
    private ProtocolHandlerPipelineFactory protocolHandlerPipelineFactory;
    private Map<String, ProtocolContext> protocolContextMapper;

    public DefaultMultiProtocolHandlerPipeline(ProtocolManager protocolManager, ProtocolHandlerPipelineFactory protocolHandlerPipelineFactory) {
        this.protocolManager = protocolManager;
        this.protocolHandlerPipelineFactory = protocolHandlerPipelineFactory;
        this.protocolContextMapper = this.initProtocolContextMapper();
    }

    protected void initChannel(Channel channel) throws Exception {
        channel.pipeline().addLast(new ChannelHandler[]{new ProtocolResolver(this.protocolManager, this.protocolContextMapper)});
    }

    protected ProtocolContext newProtocolContext(ProtocolService protocol) {
        ChannelHandler handlerPipeline = this.protocolHandlerPipelineFactory.createPipeline((Protocol)protocol);
        return new ProtocolContext(protocol, handlerPipeline);
    }

    protected Map<String, ProtocolContext> initProtocolContextMapper() {
        HashMap result = Maps.newHashMap();
        for (ProtocolService protocol : this.protocolManager.getProtocolServices()) {
            ProtocolContext protocolContext = this.newProtocolContext(protocol);
            result.put(protocol.type(), protocolContext);
        }
        return result;
    }
}

