/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.protocol.support;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import org.joyqueue.network.event.TransportEventHandler;
import org.joyqueue.network.handler.ConnectionHandler;
import org.joyqueue.network.protocol.CommandHandlerProvider;
import org.joyqueue.network.protocol.Protocol;
import org.joyqueue.network.transport.codec.Codec;
import org.joyqueue.network.transport.codec.CodecFactory;
import org.joyqueue.network.transport.codec.support.NettyDecoder;
import org.joyqueue.network.transport.codec.support.NettyEncoder;
import org.joyqueue.network.transport.command.CommandDispatcher;
import org.joyqueue.network.transport.handler.CommandInvocation;

@ChannelHandler.Sharable
public class DefaultProtocolHandlerPipeline
extends ChannelInitializer {
    private Protocol protocol;
    private CommandDispatcher commandDispatcher;
    private TransportEventHandler transportEventHandler;
    private ConnectionHandler connectionHandler;
    private CommandInvocation commandInvocation;
    private Codec codec;

    public DefaultProtocolHandlerPipeline(Protocol protocol, CommandDispatcher commandDispatcher, TransportEventHandler transportEventHandler, ConnectionHandler connectionHandler) {
        this.protocol = protocol;
        this.commandDispatcher = commandDispatcher;
        this.transportEventHandler = transportEventHandler;
        this.connectionHandler = connectionHandler;
        this.commandInvocation = this.newCommandInvocation();
        CodecFactory codecFactory = protocol.createCodecFactory();
        if (codecFactory != null) {
            this.codec = codecFactory.getCodec();
        }
    }

    protected void initChannel(Channel channel) throws Exception {
        if (this.codec == null) {
            throw new IllegalArgumentException(String.format("codec is null, protocol: %s", this.protocol.type()));
        }
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new NettyDecoder(this.codec)}).addLast(new ChannelHandler[]{new NettyEncoder(this.codec)}).addLast(new ChannelHandler[]{this.connectionHandler}).addLast(new ChannelHandler[]{this.transportEventHandler});
        if (this.protocol instanceof CommandHandlerProvider) {
            ChannelHandler customHandler = ((CommandHandlerProvider)this.protocol).getCommandHandler((ChannelHandler)this.commandInvocation);
            if (customHandler != null) {
                pipeline.addLast(new ChannelHandler[]{customHandler});
            } else {
                pipeline.addLast(new ChannelHandler[]{this.commandInvocation});
            }
        } else {
            pipeline.addLast(new ChannelHandler[]{this.commandInvocation});
        }
    }

    protected CommandInvocation newCommandInvocation() {
        return new CommandInvocation(this.commandDispatcher);
    }
}

