/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.protocol.support;

import io.netty.channel.ChannelHandler;
import java.util.concurrent.ExecutorService;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.network.protocol.support.CommandHandlerFactoryWrapper;
import org.joyqueue.network.protocol.ChannelHandlerProvider;
import org.joyqueue.network.protocol.CommandHandlerProvider;
import org.joyqueue.network.protocol.ExceptionHandlerProvider;
import org.joyqueue.network.protocol.ProtocolServer;
import org.joyqueue.network.transport.codec.CodecFactory;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.network.transport.config.ServerConfig;
import org.joyqueue.toolkit.lang.LifeCycle;

public class ProtocolServerWrapper
implements LifeCycle,
ProtocolServer,
BrokerContextAware,
ExceptionHandlerProvider,
CommandHandlerProvider,
ChannelHandlerProvider {
    private ProtocolServer delegate;
    private ExecutorService commonThreadPool;
    private ExecutorService fetchThreadPool;
    private ExecutorService produceThreadPool;

    public ProtocolServerWrapper(ProtocolServer delegate, ExecutorService commonThreadPool, ExecutorService fetchThreadPool, ExecutorService produceThreadPool) {
        this.delegate = delegate;
        this.commonThreadPool = commonThreadPool;
        this.fetchThreadPool = fetchThreadPool;
        this.produceThreadPool = produceThreadPool;
    }

    public void start() throws Exception {
        if (this.delegate instanceof LifeCycle) {
            ((LifeCycle)this.delegate).start();
        }
    }

    public void stop() {
        if (this.delegate instanceof LifeCycle) {
            ((LifeCycle)this.delegate).stop();
        }
    }

    public boolean isStarted() {
        if (this.delegate instanceof LifeCycle) {
            return ((LifeCycle)this.delegate).isStarted();
        }
        return false;
    }

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        if (this.delegate instanceof BrokerContextAware) {
            ((BrokerContextAware)this.delegate).setBrokerContext(brokerContext);
        }
    }

    public ChannelHandler getChannelHandler(ChannelHandler channelHandler) {
        if (this.delegate instanceof ChannelHandlerProvider) {
            return ((ChannelHandlerProvider)this.delegate).getChannelHandler(channelHandler);
        }
        return null;
    }

    public ChannelHandler getCommandHandler(ChannelHandler channelHandler) {
        if (this.delegate instanceof CommandHandlerProvider) {
            return ((CommandHandlerProvider)this.delegate).getCommandHandler(channelHandler);
        }
        return null;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.delegate instanceof ExceptionHandlerProvider) {
            return ((ExceptionHandlerProvider)this.delegate).getExceptionHandler();
        }
        return null;
    }

    public ServerConfig createServerConfig(ServerConfig serverConfig) {
        return this.delegate.createServerConfig(serverConfig);
    }

    public CodecFactory createCodecFactory() {
        return this.delegate.createCodecFactory();
    }

    public CommandHandlerFactory createCommandHandlerFactory() {
        return new CommandHandlerFactoryWrapper(this.delegate.createCommandHandlerFactory(), this.commonThreadPool, this.fetchThreadPool, this.produceThreadPool);
    }

    public String type() {
        return this.delegate.type();
    }
}

