/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.protocol.support;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import java.util.concurrent.ExecutorService;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.network.protocol.support.CommandHandlerFactoryWrapper;
import org.joyqueue.network.protocol.ChannelHandlerProvider;
import org.joyqueue.network.protocol.CommandHandlerProvider;
import org.joyqueue.network.protocol.ExceptionHandlerProvider;
import org.joyqueue.network.protocol.ProtocolService;
import org.joyqueue.network.transport.codec.CodecFactory;
import org.joyqueue.network.transport.command.handler.CommandHandlerFactory;
import org.joyqueue.network.transport.command.handler.ExceptionHandler;
import org.joyqueue.toolkit.lang.LifeCycle;

public class ProtocolServiceWrapper
implements LifeCycle,
ProtocolService,
BrokerContextAware,
ExceptionHandlerProvider,
CommandHandlerProvider,
ChannelHandlerProvider {
    private ProtocolService delegate;
    private ExecutorService commonThreadPool;
    private ExecutorService fetchThreadPool;
    private ExecutorService produceThreadPool;

    public ProtocolServiceWrapper(ProtocolService delegate, ExecutorService commonThreadPool, ExecutorService fetchThreadPool, ExecutorService produceThreadPool) {
        this.delegate = delegate;
        this.commonThreadPool = commonThreadPool;
        this.fetchThreadPool = fetchThreadPool;
        this.produceThreadPool = produceThreadPool;
    }

    public void start() throws Exception {
        if (this.delegate instanceof LifeCycle) {
            ((LifeCycle)this.delegate).start();
        }
    }

    public void stop() {
        if (this.delegate instanceof LifeCycle) {
            ((LifeCycle)this.delegate).stop();
        }
    }

    public boolean isStarted() {
        if (this.delegate instanceof LifeCycle) {
            return ((LifeCycle)this.delegate).isStarted();
        }
        return false;
    }

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        if (this.delegate instanceof BrokerContextAware) {
            ((BrokerContextAware)this.delegate).setBrokerContext(brokerContext);
        }
    }

    public ChannelHandler getChannelHandler(ChannelHandler channelHandler) {
        if (this.delegate instanceof ChannelHandlerProvider) {
            return ((ChannelHandlerProvider)this.delegate).getChannelHandler(channelHandler);
        }
        return null;
    }

    public ChannelHandler getCommandHandler(ChannelHandler channelHandler) {
        if (this.delegate instanceof CommandHandlerProvider) {
            return ((CommandHandlerProvider)this.delegate).getCommandHandler(channelHandler);
        }
        return null;
    }

    public ExceptionHandler getExceptionHandler() {
        if (this.delegate instanceof ExceptionHandlerProvider) {
            return ((ExceptionHandlerProvider)this.delegate).getExceptionHandler();
        }
        return null;
    }

    public boolean isSupport(ByteBuf buffer) {
        return this.delegate.isSupport(buffer);
    }

    public CodecFactory createCodecFactory() {
        return this.delegate.createCodecFactory();
    }

    public CommandHandlerFactory createCommandHandlerFactory() {
        return new CommandHandlerFactoryWrapper(this.delegate.createCommandHandlerFactory(), this.commonThreadPool, this.fetchThreadPool, this.produceThreadPool);
    }

    public String type() {
        return this.delegate.type();
    }
}

