/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.network.traffic;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;

public class Traffic {
    private Map<String, Integer> topicTraffic;
    private Map<String, Integer> topicTps;
    private Map<String, Boolean> isLimited;
    private boolean limited = false;
    private String app;

    public Traffic() {
    }

    public Traffic(String app) {
        this.app = app;
    }

    public void record(String topic, int traffic, int tps) {
        this.recordTps(topic, tps);
        this.recordTraffic(topic, traffic);
    }

    public void recordTps(String topic, int tps) {
        if (this.topicTps == null) {
            this.topicTps = Maps.newHashMap();
        }
        tps = (Integer)ObjectUtils.defaultIfNull((Object)this.topicTps.get(topic), (Object)0) + tps;
        this.topicTps.put(topic, tps);
    }

    public void recordTraffic(String topic, int traffic) {
        if (this.topicTraffic == null) {
            this.topicTraffic = Maps.newHashMap();
        }
        traffic = (Integer)ObjectUtils.defaultIfNull((Object)this.topicTraffic.get(topic), (Object)0) + traffic;
        this.topicTraffic.put(topic, traffic);
    }

    public List<String> getTopics() {
        if (this.topicTraffic == null) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(this.topicTraffic.keySet());
    }

    public void limited(boolean limited) {
        this.limited = limited;
    }

    public boolean isLimited() {
        return this.limited;
    }

    public void limited(String topic, boolean limited) {
        if (this.isLimited == null) {
            this.isLimited = Maps.newHashMap();
        }
        this.isLimited.put(topic, limited);
    }

    public boolean isLimited(String topic) {
        if (this.limited) {
            return true;
        }
        if (this.isLimited == null) {
            return false;
        }
        Boolean result = this.isLimited.get(topic);
        if (result == null) {
            return false;
        }
        return result;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public String getApp() {
        return this.app;
    }

    public int getTraffic(String topic) {
        if (this.topicTraffic == null) {
            return 0;
        }
        return this.topicTraffic.get(topic);
    }

    public int getTps(String topic) {
        if (this.topicTps == null) {
            return 1;
        }
        return this.topicTps.get(topic);
    }
}

