/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.polling;

import com.google.common.base.Preconditions;
import com.jd.laf.extension.Converts;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.model.PullResult;
import org.joyqueue.broker.monitor.SessionManager;
import org.joyqueue.broker.polling.LongPolling;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.network.session.Consumer;
import org.joyqueue.network.session.Joint;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.service.ServiceThread;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LongPollingManager
extends Service {
    public static final String LONG_POLLING_QUEUE_SIZE = "broker.consume.long_polling_queue_size";
    public static final int MAX_LONG_POLLING_QUEUE_SIZE = 10000;
    protected static Logger logger = LoggerFactory.getLogger(LongPollingManager.class);
    protected Queue<LongPolling> longPollingQueue = new LinkedBlockingQueue<LongPolling>();
    protected ConcurrentMap<Joint, AtomicInteger> counter = new ConcurrentHashMap<Joint, AtomicInteger>();
    protected Consume consumeManager;
    protected SessionManager sessionManager;
    protected Thread guardThread = null;
    protected ExecutorService executorService;
    protected ClusterManager clusterManager;
    protected PropertySupplier propertySupplier;

    public LongPollingManager(SessionManager sessionManager, ClusterManager clusterManager, Consume consumeManager, PropertySupplier propertySupplier) {
        Preconditions.checkArgument((sessionManager != null ? 1 : 0) != 0, (Object)"sessionManager can not be null");
        Preconditions.checkArgument((clusterManager != null ? 1 : 0) != 0, (Object)"clusterManager can not be null");
        Preconditions.checkArgument((consumeManager != null ? 1 : 0) != 0, (Object)"consumeManager can not be null");
        Preconditions.checkArgument((propertySupplier != null ? 1 : 0) != 0, (Object)"propertySupplier can not be null");
        this.sessionManager = sessionManager;
        this.clusterManager = clusterManager;
        this.consumeManager = consumeManager;
        this.propertySupplier = propertySupplier;
        this.executorService = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("LongPolling"));
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.counter.clear();
        this.guardThread = new Thread((Runnable)new ServiceThread(this, 100L){

            public boolean onException(Throwable e) {
                logger.error(e.getMessage(), e);
                return true;
            }

            protected void execute() throws Exception {
                LongPollingManager.this.processHoldRequest();
            }
        }, "LongPolling-Thread");
        this.guardThread.start();
        logger.info("long polling manager is started");
    }

    protected void doStop() {
        super.doStop();
        if (this.guardThread != null) {
            this.guardThread.interrupt();
        }
        this.counter.clear();
        logger.info("long pull manager is stopped");
    }

    protected AtomicInteger getCount(Consumer consumer) {
        AtomicInteger count = (AtomicInteger)this.counter.get(consumer.getJoint());
        if (count == null) {
            count = new AtomicInteger(0);
            AtomicInteger old = this.counter.putIfAbsent(consumer.getJoint(), count);
            if (old != null) {
                count = old;
            }
        }
        return count;
    }

    public boolean suspend(LongPolling longPolling) {
        logger.debug("longPolling info:[{}], longPollingQueueSize:[{}]", (Object)longPolling, (Object)this.longPollingQueue.size());
        Consumer consumer = longPolling.getConsumer();
        if (consumer == null || longPolling.getLongPollingTimeout() == 0L || !this.isStarted()) {
            return false;
        }
        String topic = consumer.getTopic();
        AtomicInteger count = this.getCount(consumer);
        List<Short> masterPartitionList = this.clusterManager.getLocalPartitions(TopicName.parse((String)topic));
        if (count.get() >= masterPartitionList.size()) {
            return false;
        }
        if (this.longPollingQueue.size() >= this.getLongPollingQueueSize()) {
            return false;
        }
        if (this.longPollingQueue.offer(longPolling)) {
            count.incrementAndGet();
            return true;
        }
        return false;
    }

    private int getLongPollingQueueSize() {
        Property property = this.propertySupplier.getProperty(LONG_POLLING_QUEUE_SIZE);
        if (property == null) {
            return 10000;
        }
        return Converts.getInteger((Object)property.getValue());
    }

    protected void processHoldRequest() throws Exception {
        int size = this.longPollingQueue.size();
        for (int i = 0; i < size; ++i) {
            if (!this.isStarted()) {
                return;
            }
            long currentTime = SystemClock.now();
            LongPolling longPolling = this.longPollingQueue.poll();
            Consumer consumer = longPolling.getConsumer();
            AtomicInteger count = (AtomicInteger)this.counter.get(consumer.getJoint());
            if ((consumer = this.sessionManager.getConsumerById(consumer.getId())) == null) {
                if (count != null) {
                    count.decrementAndGet();
                }
                longPolling.getLongPollingCallback().onExpire(longPolling.getConsumer());
                continue;
            }
            if (longPolling.getExpire() <= currentTime) {
                if (count != null) {
                    count.decrementAndGet();
                }
                longPolling.getLongPollingCallback().onExpire(consumer);
                continue;
            }
            if (this.consumeManager.hasFreePartition(consumer)) {
                this.executorService.execute(new PullMessageTask(longPolling));
                continue;
            }
            this.longPollingQueue.offer(longPolling);
        }
    }

    protected class PullMessageTask
    implements Runnable {
        private final LongPolling longPolling;

        public PullMessageTask(LongPolling longPolling) {
            this.longPolling = longPolling;
        }

        @Override
        public void run() {
            if (!LongPollingManager.this.isStarted()) {
                return;
            }
            Consumer consumer = this.longPolling.getConsumer();
            AtomicInteger count = (AtomicInteger)LongPollingManager.this.counter.get(consumer.getJoint());
            PullResult pullResult = null;
            try {
                pullResult = LongPollingManager.this.consumeManager.getMessage(consumer, this.longPolling.getCount(), this.longPolling.getAckTimeout());
                if (pullResult != null && pullResult.getBuffers().size() > 0) {
                    this.longPolling.getLongPollingCallback().onSuccess(consumer, pullResult);
                    if (count != null) {
                        count.decrementAndGet();
                    }
                } else if (LongPollingManager.this.isStarted()) {
                    LongPollingManager.this.longPollingQueue.offer(this.longPolling);
                }
                if (!pullResult.getCode().equals((Object)JoyQueueCode.SUCCESS)) {
                    logger.error("getMessage error, code: {}, consumer: {}", (Object)pullResult.getCode(), (Object)consumer);
                }
            }
            catch (Throwable th) {
                try {
                    logger.error("long pull error.", th);
                    if (count != null) {
                        count.decrementAndGet();
                    }
                    this.longPolling.getLongPollingCallback().onException(consumer, th);
                }
                catch (Exception e) {
                    logger.error("ack long pull error.", (Throwable)e);
                }
            }
        }
    }
}

