/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.producer;

import org.joyqueue.broker.config.BrokerConfig;
import org.joyqueue.broker.producer.ProducerConfigKey;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;

public class ProduceConfig {
    private PropertySupplier propertySupplier;
    private BrokerConfig brokerConfig;

    public ProduceConfig(PropertySupplier propertySupplier) {
        this.propertySupplier = propertySupplier;
        this.brokerConfig = new BrokerConfig(propertySupplier);
    }

    public int getTopicQosLevel(String topic) {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (String)(ProducerConfigKey.TOPIC_QOS_LEVEL_PREFIX.getName() + topic), (PropertyDef.Type)ProducerConfigKey.TOPIC_QOS_LEVEL_PREFIX.getType(), (Object)ProducerConfigKey.TOPIC_QOS_LEVEL_PREFIX.getValue());
    }

    public int getAppQosLevel(String app) {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (String)(ProducerConfigKey.APP_QOS_LEVEL_PREFIX.getName() + app), (PropertyDef.Type)ProducerConfigKey.APP_QOS_LEVEL_PREFIX.getType(), (Object)ProducerConfigKey.APP_QOS_LEVEL_PREFIX.getValue());
    }

    public int getFeedbackTimeout() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ProducerConfigKey.FEEDBACK_TIMEOUT);
    }

    public int getTransactionExpireClearInterval() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ProducerConfigKey.TRANSACTION_CLEAR_INTERVAL);
    }

    public int getTransactionMaxUncomplete() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ProducerConfigKey.TRANSACTION_MAX_UNCOMPLETE);
    }

    public int getTransactionExpireTime() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ProducerConfigKey.TRANSACTION_EXPIRE_TIME);
    }

    public int getFixThreadPoolNThreads() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ProducerConfigKey.FIX_THREAD_POOL_THREADS);
    }

    public int getBrokerQosLevel() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ProducerConfigKey.BROKER_QOS_LEVEL);
    }

    public long getPrintMetricIntervalMs() {
        return (Long)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ProducerConfigKey.PRINT_METRIC_INTERVAL_MS);
    }

    public int getBusinessIdLength() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ProducerConfigKey.PRODUCE_BUSINESSID_LENGTH);
    }

    public int getBodyLength() {
        return (Integer)PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)ProducerConfigKey.PRODUCE_BODY_LENGTH);
    }

    public boolean getLogDetail(String app) {
        return this.brokerConfig.getLogDetail(app);
    }
}

