/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.producer.transaction;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.producer.ProduceConfig;
import org.joyqueue.broker.producer.transaction.UnCompletedTransactionManager;
import org.joyqueue.network.session.TransactionId;
import org.joyqueue.store.StoreService;
import org.joyqueue.store.transaction.TransactionStore;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCleaner
extends Service
implements Runnable {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionCleaner.class);
    private ProduceConfig config;
    private UnCompletedTransactionManager unCompletedTransactionManager;
    private StoreService store;
    private ScheduledExecutorService clearThreadPool;

    public TransactionCleaner(ProduceConfig config, UnCompletedTransactionManager unCompletedTransactionManager, StoreService store) {
        this.config = config;
        this.unCompletedTransactionManager = unCompletedTransactionManager;
        this.store = store;
    }

    protected void validate() throws Exception {
        this.clearThreadPool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("joyqueue-transaction-clear"));
    }

    protected void doStart() throws Exception {
        this.clearThreadPool.scheduleWithFixedDelay(this, this.config.getTransactionExpireClearInterval(), this.config.getTransactionExpireClearInterval(), TimeUnit.MILLISECONDS);
    }

    protected void doStop() {
        if (this.clearThreadPool != null) {
            this.clearThreadPool.shutdown();
        }
    }

    @Override
    public void run() {
        LinkedList expiredTransactions = Lists.newLinkedList();
        ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, TransactionId>>> appTransactions = this.unCompletedTransactionManager.getTransactions();
        for (Map.Entry appEntry : appTransactions.entrySet()) {
            for (Map.Entry topicEntry : ((ConcurrentMap)appEntry.getValue()).entrySet()) {
                ConcurrentMap transactions = (ConcurrentMap)topicEntry.getValue();
                for (Map.Entry transactionEntry : transactions.entrySet()) {
                    TransactionId transactionId = (TransactionId)transactionEntry.getValue();
                    if (!this.isExpired((TransactionId)transactionEntry.getValue())) continue;
                    expiredTransactions.add(transactionId);
                }
            }
        }
        for (TransactionId expiredTransaction : expiredTransactions) {
            this.doClear(expiredTransaction);
        }
    }

    protected boolean isExpired(TransactionId transactionId) {
        if (transactionId.isFeedback()) {
            return transactionId.isExpired((long)this.config.getTransactionExpireTime());
        }
        return transactionId.isTimeout();
    }

    protected void doClear(TransactionId transactionId) {
        try {
            TransactionStore transactionStore = this.store.getTransactionStore(transactionId.getTopic());
            if (transactionStore == null) {
                logger.error("clear expired transaction error, store not exist, topic: {}, app : {}, txId: {}, storeId: {}", new Object[]{transactionId.getTopic(), transactionId.getApp(), transactionId.getTxId(), transactionId.getStoreId()});
                return;
            }
            Iterator rByteBufferIterator = transactionStore.readIterator(transactionId.getStoreId());
            if (rByteBufferIterator == null) {
                logger.error("clear expired transaction error, store iterator not exist, topic: {}, app : {}, txId: {}, storeId: {}", new Object[]{transactionId.getTopic(), transactionId.getApp(), transactionId.getTxId(), transactionId.getStoreId()});
                return;
            }
            transactionStore.remove(transactionId.getStoreId());
            this.unCompletedTransactionManager.removeTransaction(transactionId.getTopic(), transactionId.getApp(), transactionId.getTxId());
            logger.info("clear expired transaction, topic: {}, app : {}, txId: {}, storeId: {}", new Object[]{transactionId.getTopic(), transactionId.getApp(), transactionId.getTxId(), transactionId.getStoreId()});
        }
        catch (Exception e) {
            logger.error("clear expired transaction exception, topic: {}, app : {}, txId: {}, storeId: {}", new Object[]{transactionId.getTopic(), transactionId.getApp(), transactionId.getTxId(), transactionId.getStoreId(), e});
        }
    }
}

