/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.producer.transaction;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.monitor.BrokerMonitor;
import org.joyqueue.broker.producer.ProduceConfig;
import org.joyqueue.broker.producer.transaction.TransactionCleaner;
import org.joyqueue.broker.producer.transaction.TransactionRecover;
import org.joyqueue.broker.producer.transaction.UnCompletedTransactionManager;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Producer;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.domain.TopicName;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerCommit;
import org.joyqueue.message.BrokerPrepare;
import org.joyqueue.message.BrokerRollback;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.session.TransactionId;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.StoreService;
import org.joyqueue.store.WriteRequest;
import org.joyqueue.store.WriteResult;
import org.joyqueue.store.message.MessageParser;
import org.joyqueue.store.transaction.TransactionStore;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager
extends Service {
    private static final Logger logger = LoggerFactory.getLogger(TransactionManager.class);
    private final AtomicLong sequence = new AtomicLong();
    private ProduceConfig config;
    private StoreService store;
    private ClusterManager clusterManager;
    private BrokerMonitor brokerMonitor;
    private UnCompletedTransactionManager unCompletedTransactionManager;
    private TransactionRecover transactionRecover;
    private TransactionCleaner transactionCleaner;

    public TransactionManager(ProduceConfig config, StoreService store, ClusterManager clusterManager, BrokerMonitor brokerMonitor) {
        this.config = config;
        this.store = store;
        this.clusterManager = clusterManager;
        this.brokerMonitor = brokerMonitor;
    }

    public TransactionId prepare(Producer producer, BrokerPrepare prepare) throws JoyQueueException {
        if (this.unCompletedTransactionManager.getTransactionCount(producer.getTopic(), producer.getApp()) > this.config.getTransactionMaxUncomplete()) {
            logger.warn("too many transactions, topic: {}, app: {}. txId: {}", new Object[]{prepare.getTopic(), prepare.getApp(), prepare.getTxId()});
            throw new JoyQueueException(JoyQueueCode.FW_TRANSACTION_LIMIT, new Object[0]);
        }
        TransactionStore transactionStore = this.store.getTransactionStore(producer.getTopic());
        if (transactionStore == null) {
            logger.error("transaction store not exist, topic: {}", (Object)producer.getTopic());
            throw new JoyQueueException(JoyQueueCode.CN_TRANSACTION_NOT_EXISTS, new Object[0]);
        }
        int storeId = transactionStore.next();
        TransactionId transactionId = this.generateTransactionId(prepare, storeId);
        try {
            this.unCompletedTransactionManager.putTransaction(transactionId);
            ByteBuffer buffer = ByteBuffer.allocate(Serializer.sizeOfBrokerPrepare(prepare));
            Serializer.writeBrokerPrepare(prepare, buffer);
            buffer.flip();
            Future prepareFuture = transactionStore.asyncWrite(storeId, new ByteBuffer[]{buffer.slice()});
            this.waitFuture(producer, prepareFuture);
        }
        catch (Exception e) {
            try {
                transactionStore.remove(storeId);
                this.unCompletedTransactionManager.removeTransaction(transactionId);
            }
            catch (Exception ex) {
                logger.error("clear prepare exception, topic: {}, app: {}. txId: {}", new Object[]{prepare.getTopic(), prepare.getApp(), prepare.getTxId(), ex});
            }
            logger.error("write prepare exception, topic: {}, app: {}. txId: {}", new Object[]{prepare.getTopic(), prepare.getApp(), prepare.getTxId(), e});
            throw new JoyQueueException(JoyQueueCode.CN_TRANSACTION_PREPARE_ERROR, new Object[0]);
        }
        return transactionId;
    }

    protected TransactionId generateTransactionId(BrokerPrepare prepare, int storeId) {
        long now = SystemClock.now();
        String txId = prepare.getTxId();
        if (StringUtils.isBlank((CharSequence)txId)) {
            txId = String.format("transactionId_%s_%s_%s_%s", prepare.getTopic(), prepare.getApp(), this.sequence.getAndIncrement(), now);
        }
        return new TransactionId(prepare.getTopic(), prepare.getApp(), txId, prepare.getQueryId(), storeId, prepare.getSource(), prepare.getTimeout(), now);
    }

    public TransactionId commit(Producer producer, BrokerCommit commit) throws JoyQueueException {
        TransactionStore transactionStore = this.store.getTransactionStore(producer.getTopic());
        if (transactionStore == null) {
            logger.error("transaction store not exist, topic: {}", (Object)producer.getTopic());
            throw new JoyQueueException(JoyQueueCode.CN_TRANSACTION_NOT_EXISTS, new Object[0]);
        }
        TransactionId transactionId = this.unCompletedTransactionManager.getTransaction(commit.getTopic(), commit.getApp(), commit.getTxId());
        if (transactionId == null) {
            logger.debug("The current tx is not in txManager, topic: {}, app: {}, txId: {}", new Object[]{commit.getTxId(), commit.getApp(), commit.getTxId()});
            throw new JoyQueueException(JoyQueueCode.CN_TRANSACTION_NOT_EXISTS, new Object[0]);
        }
        BrokerPrepare brokerPrepare = null;
        HashMap writeRequestMap = Maps.newHashMap();
        int messageSize = 0;
        try {
            int index = 0;
            Iterator readIterator = transactionStore.readIterator(transactionId.getStoreId());
            while (readIterator.hasNext()) {
                ByteBuffer byteBuffer = (ByteBuffer)readIterator.next();
                if (index == 0) {
                    brokerPrepare = Serializer.readBrokerPrepare(byteBuffer);
                } else {
                    short s = this.dispatchPartition(byteBuffer, (short)0);
                    PartitionGroup partitionGroup = this.clusterManager.getPartitionGroup(TopicName.parse((String)producer.getTopic()), s);
                    if (partitionGroup == null) {
                        throw new JoyQueueException(JoyQueueCode.SE_WRITE_FAILED, new Object[0]);
                    }
                    List writeRequests = (List)writeRequestMap.get(partitionGroup.getGroup());
                    if (writeRequests == null) {
                        writeRequests = Lists.newLinkedList();
                        writeRequestMap.put(partitionGroup.getGroup(), writeRequests);
                    }
                    writeRequests.add(new WriteRequest(s, byteBuffer, 1));
                    messageSize += byteBuffer.limit();
                }
                ++index;
            }
            try {
                for (Map.Entry entry : writeRequestMap.entrySet()) {
                    PartitionGroupStore partitionStoreService = this.store.getStore(commit.getTopic(), ((Integer)entry.getKey()).intValue(), QosLevel.REPLICATION);
                    long startTime = SystemClock.now();
                    Future future = partitionStoreService.asyncWrite(((List)entry.getValue()).toArray(new WriteRequest[0]));
                    this.waitFuture(producer, future);
                    long endTime = SystemClock.now();
                    for (WriteRequest writeRequest : (List)entry.getValue()) {
                        this.brokerMonitor.onPutMessage(producer.getTopic(), producer.getApp(), (Integer)entry.getKey(), writeRequest.getPartition(), 1L, messageSize, endTime - startTime);
                    }
                }
            }
            catch (Exception e) {
                logger.warn("write transaction message exception, topic: {}, app: {}, txId: {}", new Object[]{brokerPrepare.getTopic(), brokerPrepare.getApp(), brokerPrepare.getTxId(), e});
                throw new JoyQueueException(JoyQueueCode.SE_IO_ERROR, new Object[0]);
            }
            this.unCompletedTransactionManager.removeTransaction(transactionId);
        }
        catch (Exception e) {
            logger.error("write transaction message exception, topic: {}, app: {}, txId: {}", new Object[]{commit.getTopic(), commit.getApp(), commit.getTxId(), e});
            if (e instanceof JoyQueueException) {
                throw (JoyQueueException)((Object)e);
            }
            throw new JoyQueueException(JoyQueueCode.SE_IO_ERROR, new Object[0]);
        }
        return transactionId;
    }

    protected short dispatchPartition(ByteBuffer msg, short defaultPartition) {
        short partition = MessageParser.getShort((ByteBuffer)msg, (int)MessageParser.PARTITION);
        return partition < 0 ? defaultPartition : partition;
    }

    protected void waitFuture(Producer producer, Future<WriteResult> future) throws JoyQueueException {
        try {
            int configTimeOut;
            Producer.ProducerPolicy producerPolicy = this.clusterManager.tryGetProducerPolicy(TopicName.parse((String)producer.getTopic()), producer.getApp());
            int n = configTimeOut = producerPolicy == null ? 0 : producerPolicy.getTimeOut();
            if (configTimeOut == 0) {
                future.get();
            } else {
                future.get(configTimeOut, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException e) {
            throw new JoyQueueException(JoyQueueCode.SE_DISK_FLUSH_SLOW, new Object[0]);
        }
        catch (ExecutionException | TimeoutException e) {
            throw new JoyQueueException(JoyQueueCode.SE_WRITE_TIMEOUT, new Object[0]);
        }
        catch (Exception e) {
            throw new JoyQueueException(JoyQueueCode.CN_CONNECTION_TIMEOUT, new Object[0]);
        }
    }

    public TransactionId rollback(Producer producer, BrokerRollback rollback) throws JoyQueueException {
        TransactionStore transactionStore = this.store.getTransactionStore(producer.getTopic());
        if (transactionStore == null) {
            logger.error("transaction store not exist, topic: {}", (Object)producer.getTopic());
            throw new JoyQueueException(JoyQueueCode.CN_TRANSACTION_NOT_EXISTS, new Object[0]);
        }
        TransactionId transactionId = this.unCompletedTransactionManager.getTransaction(rollback.getTopic(), rollback.getApp(), rollback.getTxId());
        if (transactionId == null) {
            logger.debug("transaction not exist, topic: {}, id: {}", (Object)producer.getTopic(), (Object)rollback.getTxId());
            throw new JoyQueueException(JoyQueueCode.CN_TRANSACTION_NOT_EXISTS, new Object[0]);
        }
        transactionStore.remove(transactionId.getStoreId());
        this.unCompletedTransactionManager.removeTransaction(transactionId);
        return transactionId;
    }

    public Future<WriteResult> putMessage(Producer producer, String txId, ByteBuffer ... byteBuffers) throws JoyQueueException {
        TransactionStore transactionStore = this.store.getTransactionStore(producer.getTopic());
        if (Strings.isNullOrEmpty((String)txId)) {
            logger.error("The current message is not a tx message!");
            throw new JoyQueueException(JoyQueueCode.CN_UNKNOWN_ERROR, new Object[0]);
        }
        TransactionId transactionId = this.unCompletedTransactionManager.getTransaction(producer.getTopic(), producer.getApp(), txId);
        if (transactionId == null) {
            logger.debug("The current tx is not in txManager! txId:{}...", (Object)txId);
            throw new JoyQueueException(JoyQueueCode.CN_TRANSACTION_NOT_EXISTS, new Object[0]);
        }
        return transactionStore.asyncWrite(transactionId.getStoreId(), byteBuffers);
    }

    public TransactionId getTransaction(String topic, String app, String txId) {
        return this.unCompletedTransactionManager.getTransaction(topic, app, txId);
    }

    public List<TransactionId> getFeedback(Producer producer, int count) {
        return this.unCompletedTransactionManager.getFeedback(producer, count);
    }

    protected void validate() throws Exception {
        this.unCompletedTransactionManager = new UnCompletedTransactionManager(this.config);
        this.transactionRecover = new TransactionRecover(this.config, this.unCompletedTransactionManager, this.store);
        this.transactionCleaner = new TransactionCleaner(this.config, this.unCompletedTransactionManager, this.store);
    }

    protected void doStart() throws Exception {
        this.transactionRecover.recover();
        this.transactionCleaner.start();
    }

    protected void doStop() {
        if (this.transactionCleaner != null) {
            this.transactionCleaner.stop();
        }
    }
}

