/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.producer.transaction;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.buffer.Serializer;
import org.joyqueue.broker.producer.ProduceConfig;
import org.joyqueue.broker.producer.transaction.UnCompletedTransactionManager;
import org.joyqueue.message.BrokerPrepare;
import org.joyqueue.network.session.TransactionId;
import org.joyqueue.store.StoreService;
import org.joyqueue.store.transaction.TransactionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionRecover {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionRecover.class);
    private ProduceConfig config;
    private UnCompletedTransactionManager unCompletedTransactionManager;
    private StoreService store;

    public TransactionRecover(ProduceConfig config, UnCompletedTransactionManager unCompletedTransactionManager, StoreService store) {
        this.config = config;
        this.unCompletedTransactionManager = unCompletedTransactionManager;
        this.store = store;
    }

    public void recover() {
        List allTransactionStores = this.store.getAllTransactionStores();
        if (CollectionUtils.isEmpty((Collection)allTransactionStores)) {
            return;
        }
        for (TransactionStore transactionStore : allTransactionStores) {
            this.doRecover(transactionStore);
        }
    }

    protected void doRecover(TransactionStore transactionStore) {
        int[] storeIds;
        for (int storeId : storeIds = transactionStore.list()) {
            this.doRecover(transactionStore, storeId);
        }
    }

    protected void doRecover(TransactionStore transactionStore, int storeId) {
        try {
            boolean isExpired = false;
            Iterator readIterator = transactionStore.readIterator(storeId);
            if (readIterator == null || !readIterator.hasNext()) {
                isExpired = true;
            } else {
                ByteBuffer byteBuffer = (ByteBuffer)readIterator.next();
                BrokerPrepare brokerPrepare = Serializer.readBrokerPrepare(byteBuffer);
                TransactionId transactionId = new TransactionId(brokerPrepare.getTopic(), brokerPrepare.getApp(), brokerPrepare.getTxId(), brokerPrepare.getQueryId(), storeId, brokerPrepare.getSource(), brokerPrepare.getTimeout(), brokerPrepare.getStartTime());
                if (transactionId.isExpired((long)this.config.getTransactionExpireTime())) {
                    isExpired = true;
                    logger.info("recover transaction is expired, topic: {}, app: {}, txId: {}", new Object[]{brokerPrepare.getTopic(), brokerPrepare.getApp(), brokerPrepare.getTxId()});
                } else {
                    this.unCompletedTransactionManager.putTransaction(transactionId);
                    logger.info("recover transaction, topic: {}, app: {}, txId: {}", new Object[]{brokerPrepare.getTopic(), brokerPrepare.getApp(), brokerPrepare.getTxId()});
                }
            }
            if (isExpired) {
                transactionStore.remove(storeId);
            }
        }
        catch (Exception e) {
            logger.error("recover transaction exception, store: {}, storeId: {}", new Object[]{transactionStore, storeId, e});
        }
    }
}

