/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.producer.transaction;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.joyqueue.broker.producer.ProduceConfig;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.session.TransactionId;
import org.joyqueue.toolkit.time.SystemClock;

public class UnCompletedTransactionManager {
    private ProduceConfig config;
    private ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, TransactionId>>> unCompleteTransaction = Maps.newConcurrentMap();

    public UnCompletedTransactionManager(ProduceConfig config) {
        this.config = config;
    }

    public boolean putTransaction(TransactionId transactionId) {
        return this.getOrCreateTransactionMap(transactionId.getApp(), transactionId.getTopic()).put(transactionId.getTxId(), transactionId) == null;
    }

    public boolean removeTransaction(TransactionId transactionId) {
        return this.removeTransaction(transactionId.getTopic(), transactionId.getApp(), transactionId.getTxId());
    }

    public boolean removeTransaction(String topic, String app, String txId) {
        return this.getOrCreateTransactionMap(app, topic).remove(txId) != null;
    }

    public TransactionId getTransaction(String topic, String app, String txId) {
        return (TransactionId)this.getOrCreateTransactionMap(app, topic).get(txId);
    }

    public int getTransactionCount(String topic, String app) {
        return this.getOrCreateTransactionMap(app, topic).size();
    }

    public List<TransactionId> getFeedback(Producer producer, int count) {
        ConcurrentMap<String, TransactionId> transactionMap = this.getOrCreateTransactionMap(producer.getApp(), producer.getTopic());
        ArrayList result = Lists.newArrayListWithCapacity((int)count);
        long now = SystemClock.now();
        int index = 0;
        for (Map.Entry entry : transactionMap.entrySet()) {
            TransactionId transactionId = (TransactionId)entry.getValue();
            if (!transactionId.isFeedback() || !transactionId.isTimeout()) continue;
            long lastQueryTimestamp = transactionId.getLastQueryTimestamp();
            if ((long)this.config.getFeedbackTimeout() > now - lastQueryTimestamp || !transactionId.setLastQueryTimestamp(lastQueryTimestamp, now)) continue;
            result.add(transactionId);
            if (++index < count) continue;
            break;
        }
        return result;
    }

    public ConcurrentMap<String, ConcurrentMap<String, ConcurrentMap<String, TransactionId>>> getTransactions() {
        return this.unCompleteTransaction;
    }

    protected ConcurrentMap<String, TransactionId> getOrCreateTransactionMap(String app, String topic) {
        ConcurrentMap transactionMap;
        ConcurrentMap topicMap = (ConcurrentMap)this.unCompleteTransaction.get(app);
        if (topicMap == null && this.unCompleteTransaction.putIfAbsent(app, topicMap = Maps.newConcurrentMap()) != null) {
            topicMap = (ConcurrentMap)this.unCompleteTransaction.get(app);
        }
        if ((transactionMap = (ConcurrentMap)topicMap.get(topic)) == null && topicMap.putIfAbsent(topic, transactionMap = Maps.newConcurrentMap()) != null) {
            transactionMap = (ConcurrentMap)topicMap.get(topic);
        }
        return transactionMap;
    }
}

