/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.producer.transaction.codec;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import org.joyqueue.broker.producer.transaction.command.TransactionRollbackRequest;
import org.joyqueue.network.serializer.Serializer;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.codec.PayloadCodec;
import org.joyqueue.network.transport.command.Type;

public class TransactionRollbackRequestCodec
implements PayloadCodec<JoyQueueHeader, TransactionRollbackRequest>,
Type {
    public TransactionRollbackRequest decode(JoyQueueHeader header, ByteBuf buffer) throws Exception {
        TransactionRollbackRequest transactionRollbackRequest = new TransactionRollbackRequest();
        transactionRollbackRequest.setTopic(Serializer.readString((ByteBuf)buffer, (int)2));
        transactionRollbackRequest.setApp(Serializer.readString((ByteBuf)buffer, (int)2));
        int txIdSize = buffer.readShort();
        ArrayList txIds = Lists.newArrayListWithCapacity((int)txIdSize);
        for (int i = 0; i < txIdSize; ++i) {
            txIds.add(Serializer.readString((ByteBuf)buffer, (int)2));
        }
        transactionRollbackRequest.setTxIds(txIds);
        return transactionRollbackRequest;
    }

    public void encode(TransactionRollbackRequest payload, ByteBuf buffer) throws Exception {
        Serializer.write((String)payload.getTopic(), (ByteBuf)buffer, (int)2);
        Serializer.write((String)payload.getApp(), (ByteBuf)buffer, (int)2);
        buffer.writeShort(payload.getTxIds().size());
        for (String txId : payload.getTxIds()) {
            Serializer.write((String)txId, (ByteBuf)buffer, (int)2);
        }
    }

    public int type() {
        return 71;
    }
}

