/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.producer.transaction.handler;

import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.broker.producer.transaction.command.TransactionCommitRequest;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerCommit;
import org.joyqueue.message.JoyQueueLog;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionCommitRequestHandler
implements CommandHandler,
Type {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionCommitRequestHandler.class);
    private Produce produce;

    public TransactionCommitRequestHandler(BrokerContext brokerContext) {
        this.produce = brokerContext.getProduce();
    }

    public Command handle(Transport transport, Command command) {
        TransactionCommitRequest transactionCommitRequest = (TransactionCommitRequest)((Object)command.getPayload());
        Producer producer = new Producer(transactionCommitRequest.getTopic(), transactionCommitRequest.getTopic(), transactionCommitRequest.getApp(), Producer.ProducerType.JOYQUEUE);
        int code = JoyQueueCode.SUCCESS.getCode();
        for (String txId : transactionCommitRequest.getTxIds()) {
            BrokerCommit brokerCommit = new BrokerCommit();
            brokerCommit.setTopic(transactionCommitRequest.getTopic());
            brokerCommit.setApp(transactionCommitRequest.getApp());
            brokerCommit.setTxId(txId);
            try {
                this.produce.putTransactionMessage(producer, (JoyQueueLog)brokerCommit);
            }
            catch (JoyQueueException e) {
                if (e.getCode() == JoyQueueCode.CN_TRANSACTION_NOT_EXISTS.getCode()) {
                    logger.error("commit transaction error, transaction not exists, topic: {}, app: {}, txId: {}", new Object[]{transactionCommitRequest.getTopic(), transactionCommitRequest.getApp(), txId});
                } else {
                    logger.error("commit transaction exception, topic: {}, app: {}, txId: {}", new Object[]{transactionCommitRequest.getTopic(), transactionCommitRequest.getApp(), txId, e});
                }
                if (e.getCode() == JoyQueueCode.SUCCESS.getCode()) continue;
                code = e.getCode();
            }
            catch (Exception e) {
                logger.error("commit transaction exception, topic: {}, app: {}, txId: {}", new Object[]{transactionCommitRequest.getTopic(), transactionCommitRequest.getApp(), txId, e});
                code = JoyQueueCode.CN_UNKNOWN_ERROR.getCode();
            }
        }
        return BooleanAck.build((int)code);
    }

    public int type() {
        return 70;
    }
}

