/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.producer.transaction.handler;

import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.producer.Produce;
import org.joyqueue.broker.producer.transaction.command.TransactionRollbackRequest;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.message.BrokerRollback;
import org.joyqueue.message.JoyQueueLog;
import org.joyqueue.network.command.BooleanAck;
import org.joyqueue.network.session.Producer;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.Type;
import org.joyqueue.network.transport.command.handler.CommandHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionRollbackRequestHandler
implements CommandHandler,
Type {
    protected static final Logger logger = LoggerFactory.getLogger(TransactionRollbackRequestHandler.class);
    private Produce produce;

    public TransactionRollbackRequestHandler(BrokerContext brokerContext) {
        this.produce = brokerContext.getProduce();
    }

    public Command handle(Transport transport, Command command) {
        TransactionRollbackRequest transactionRollbackRequest = (TransactionRollbackRequest)((Object)command.getPayload());
        Producer producer = new Producer(transactionRollbackRequest.getTopic(), transactionRollbackRequest.getTopic(), transactionRollbackRequest.getApp(), Producer.ProducerType.JOYQUEUE);
        int code = JoyQueueCode.SUCCESS.getCode();
        for (String txId : transactionRollbackRequest.getTxIds()) {
            BrokerRollback brokerRollback = new BrokerRollback();
            brokerRollback.setTopic(transactionRollbackRequest.getTopic());
            brokerRollback.setApp(transactionRollbackRequest.getApp());
            brokerRollback.setTxId(txId);
            try {
                this.produce.putTransactionMessage(producer, (JoyQueueLog)brokerRollback);
            }
            catch (JoyQueueException e) {
                if (e.getCode() == JoyQueueCode.CN_TRANSACTION_NOT_EXISTS.getCode()) {
                    logger.error("rollback transaction error, transaction not exists, topic: {}, app: {}, txId: {}", new Object[]{transactionRollbackRequest.getTopic(), transactionRollbackRequest.getApp(), txId});
                } else {
                    logger.error("rollback transaction exception, topic: {}, app: {}, txId: {}", new Object[]{transactionRollbackRequest.getTopic(), transactionRollbackRequest.getApp(), txId, e});
                }
                if (e.getCode() == JoyQueueCode.SUCCESS.getCode()) continue;
                code = e.getCode();
            }
            catch (Exception e) {
                logger.error("rollback transaction exception, topic: {}, app: {}, txId: {}", new Object[]{transactionRollbackRequest.getTopic(), transactionRollbackRequest.getApp(), txId, e});
                code = JoyQueueCode.CN_UNKNOWN_ERROR.getCode();
            }
        }
        return BooleanAck.build((int)code);
    }

    public int type() {
        return 71;
    }
}

