/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.replication;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.joyqueue.broker.config.BrokerConfig;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.consumer.model.ConsumePartition;
import org.joyqueue.broker.consumer.position.model.Position;
import org.joyqueue.broker.election.DefaultElectionNode;
import org.joyqueue.broker.election.ElectionConfig;
import org.joyqueue.broker.election.ElectionException;
import org.joyqueue.broker.election.ElectionNode;
import org.joyqueue.broker.election.LeaderElection;
import org.joyqueue.broker.election.TopicPartitionGroup;
import org.joyqueue.broker.election.command.AppendEntriesRequest;
import org.joyqueue.broker.election.command.AppendEntriesResponse;
import org.joyqueue.broker.election.command.ReplicateConsumePosRequest;
import org.joyqueue.broker.election.command.ReplicateConsumePosResponse;
import org.joyqueue.broker.election.command.TimeoutNowRequest;
import org.joyqueue.broker.election.command.TimeoutNowResponse;
import org.joyqueue.broker.monitor.BrokerMonitor;
import org.joyqueue.broker.replication.Replica;
import org.joyqueue.broker.replication.ReplicationManager;
import org.joyqueue.broker.replication.ReplicationTransportSession;
import org.joyqueue.domain.TopicName;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.codec.JoyQueueHeader;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.command.Direction;
import org.joyqueue.network.transport.command.Header;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.store.replication.ReplicableStore;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.joyqueue.toolkit.validate.annotation.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaGroup
extends Service {
    private static Logger logger = LoggerFactory.getLogger(ReplicaGroup.class);
    private ElectionConfig electionConfig;
    private BrokerConfig brokerConfig;
    private TopicPartitionGroup topicPartitionGroup;
    private ReplicationManager replicationManager;
    private List<Replica> replicas;
    private List<Replica> replicasWithoutLearners;
    private volatile ElectionNode.State state;
    private int localReplicaId;
    private int leaderId;
    private int currentTerm;
    private int transferee = -1;
    private long timeoutNowPosition = 0L;
    private ReplicableStore replicableStore;
    private Thread replicateThread;
    private DelayQueue<DelayedCommand> replicateResponseQueue;
    private LeaderElection leaderElection;
    private ExecutorService replicateExecutor;
    private Consume consume;
    private BrokerMonitor brokerMonitor;
    private final ConcurrentMap<String, ReplicationTransportSession> sessions = new ConcurrentHashMap<String, ReplicationTransportSession>();
    private final TransportClient transportClient;
    private static final long ONE_SECOND_NANO = 1000000000L;
    private static final long ONE_MS_NANO = 1000000L;
    private static final int MAX_PROCESS_TIME = 300000;

    ReplicaGroup(TopicPartitionGroup topicPartitionGroup, ReplicationManager replicationManager, ReplicableStore replicableStore, ElectionConfig electionConfig, BrokerConfig brokerConfig, Consume consume, ExecutorService replicateExecutor, BrokerMonitor brokerMonitor, List<DefaultElectionNode> allNodes, Set<Integer> learners, int localReplicaId, int leaderId, TransportClient transportClient) {
        Preconditions.checkArgument((electionConfig != null ? 1 : 0) != 0, (Object)"election config is null");
        Preconditions.checkArgument((topicPartitionGroup != null ? 1 : 0) != 0, (Object)"topic partition group is null");
        Preconditions.checkArgument((replicationManager != null ? 1 : 0) != 0, (Object)"replication manager is null");
        Preconditions.checkArgument((consume != null ? 1 : 0) != 0, (Object)"consume is null");
        Preconditions.checkArgument((brokerMonitor != null ? 1 : 0) != 0, (Object)"broker monitor is null");
        Preconditions.checkArgument((replicateExecutor != null ? 1 : 0) != 0, (Object)"replicate executor is null");
        Preconditions.checkArgument((replicableStore != null ? 1 : 0) != 0, (Object)"replicable store is null");
        Preconditions.checkArgument((transportClient != null ? 1 : 0) != 0, (Object)"transport client can not be null");
        this.electionConfig = electionConfig;
        this.brokerConfig = brokerConfig;
        this.topicPartitionGroup = topicPartitionGroup;
        this.replicationManager = replicationManager;
        this.localReplicaId = localReplicaId;
        this.leaderId = leaderId;
        this.consume = consume;
        this.brokerMonitor = brokerMonitor;
        this.replicateExecutor = replicateExecutor;
        this.replicableStore = replicableStore;
        this.transportClient = transportClient;
        this.replicas = allNodes.stream().map(n -> new Replica(n.getNodeId(), n.getAddress())).collect(Collectors.toList());
        this.replicasWithoutLearners = this.replicas.stream().filter(r -> !learners.contains(r.replicaId())).collect(Collectors.toList());
    }

    public void doStart() throws Exception {
        super.doStart();
        this.replicateResponseQueue = new DelayQueue();
        this.replicateThread = new ReplicateThread("ReplicateThread-" + this.topicPartitionGroup.toString());
        this.replicateThread.start();
    }

    public void doStop() {
        while (this.replicateThread.isAlive()) {
            this.replicateThread.interrupt();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.sessions != null && !this.sessions.isEmpty()) {
            for (ReplicationTransportSession transport : this.sessions.values()) {
                if (transport == null) continue;
                transport.stop();
            }
        }
        super.doStop();
    }

    public void setLeaderElection(LeaderElection leaderElection) {
        this.leaderElection = leaderElection;
    }

    public synchronized void addNode(ElectionNode node) throws ElectionException {
        try {
            Replica newReplica = new Replica(node.getNodeId(), node.getAddress());
            long nextReplicate = this.replicableStore.position(this.replicableStore.rightPosition(), -1);
            newReplica.nextPosition(nextReplicate);
            this.replicas.add(newReplica);
            this.replicateResponseQueue.put(new DelayedCommand(1000000000L, newReplica.replicaId()));
            for (Replica replica : this.replicas) {
                logger.info("Partition group {}/node {} add node, replica {}'s next position is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, replica.replicaId(), replica.nextPosition()});
            }
        }
        catch (Exception e) {
            logger.error("add node error.", (Throwable)e);
            throw new ElectionException("add node error.", e);
        }
    }

    public synchronized void removeNode(int nodeId) {
        this.replicas = this.replicas.stream().filter(r -> r.replicaId() != nodeId).collect(Collectors.toList());
        this.replicasWithoutLearners = this.replicasWithoutLearners.stream().filter(r -> r.replicaId() != nodeId).collect(Collectors.toList());
        for (Replica replica : this.replicas) {
            logger.info("Partition group {}/node {} remove node, replica {}'s next position is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, replica.replicaId(), replica.nextPosition()});
        }
    }

    private Replica getReplica(int replicaId) {
        return this.replicas.stream().filter(r -> r.replicaId() == replicaId).findFirst().orElse(null);
    }

    public void setState(ElectionNode.State state) {
        this.state = state;
        this.brokerMonitor.onReplicaStateChange(this.topicPartitionGroup.getTopic(), this.topicPartitionGroup.getPartitionGroupId(), state);
    }

    public boolean isLeader() {
        return this.state == ElectionNode.State.LEADER;
    }

    private boolean neednotReplicate() {
        return this.topicPartitionGroup.getTopic().equalsIgnoreCase("__group_coordinators");
    }

    public long lagLength(int replicaId) {
        Replica replica = this.getReplica(replicaId);
        if (replica == null) {
            return -1L;
        }
        return this.replicableStore.rightPosition() - replica.writePosition();
    }

    public void becomeLeader(int term, int leaderId) {
        this.currentTerm = term;
        this.leaderId = leaderId;
        long writePosition = this.replicableStore.rightPosition();
        this.replicas.forEach(r -> {
            r.nextPosition(writePosition);
            r.setMatch(false);
        });
        this.state = ElectionNode.State.LEADER;
        logger.info("Partition group {}/node {} become leader, term is {}, left position is {}, writePosition is {}, commit position is {}", new Object[]{this.topicPartitionGroup, leaderId, term, this.replicableStore.leftPosition(), writePosition, this.replicableStore.commitPosition()});
    }

    public void becomeFollower(int term, int leaderId) {
        logger.info("Partition group {}/node {} become follower, term is {}, leader is {}, left position is {} ,write position is {}, commit position is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, term, leaderId, this.replicableStore.leftPosition(), this.replicableStore.rightPosition(), this.replicableStore.commitPosition()});
        this.state = ElectionNode.State.FOLLOWER;
        this.currentTerm = term;
        this.leaderId = leaderId;
    }

    private void initResponseQueue() {
        this.replicateResponseQueue.clear();
        this.replicas.forEach(r -> this.replicateResponseQueue.put(new DelayedCommand(0L, r.replicaId())));
    }

    private void replicateLocal() {
        long delayTimeNs;
        if (this.replicas.size() == 1) {
            if (this.replicableStore.commitPosition() < this.replicableStore.rightPosition()) {
                this.replicableStore.commit(this.replicableStore.rightPosition());
                delayTimeNs = 0L;
            } else {
                delayTimeNs = 200000L;
            }
        } else {
            delayTimeNs = 1000000000L;
        }
        this.replicateResponseQueue.put(new DelayedCommand(delayTimeNs, this.localReplicaId));
    }

    private void replicateMessage(Replica replica) {
        try {
            this.replicateExecutor.submit(() -> {
                try {
                    long startTimeUs = this.usTime();
                    AppendEntriesRequest request = this.generateAppendEntriesRequest(replica);
                    if (request == null) {
                        this.replicateResponseQueue.put(new DelayedCommand(1000000L, replica.replicaId()));
                        return;
                    }
                    JoyQueueHeader header = new JoyQueueHeader(Direction.REQUEST, 45);
                    if (!replica.isMatch() || logger.isDebugEnabled()) {
                        logger.info("Partition group {}/node {} send append entries request {} to node {}, read entries elapse {} us", new Object[]{this.topicPartitionGroup, this.leaderId, request, replica.replicaId(), this.usTime() - startTimeUs});
                    }
                    this.sendCommand(replica.getAddress(), new Command((Header)header, (Object)request), this.electionConfig.getSendCommandTimeout(), new AppendEntriesRequestCallback(replica, startTimeUs, request.getEntriesLength()));
                }
                catch (Throwable t) {
                    logger.warn("Partition group {}/ node {} send append entries to {} fail", new Object[]{this.topicPartitionGroup, this.localReplicaId, replica.replicaId(), t});
                    this.replicateResponseQueue.put(new DelayedCommand(1000000000L, replica.replicaId()));
                }
            });
        }
        catch (Exception e) {
            logger.info("Partition group {}/node {} replicate message to {} fail", new Object[]{this.topicPartitionGroup, this.localReplicaId, replica.replicaId(), e});
            this.replicateResponseQueue.put(new DelayedCommand(1000000000L, replica.replicaId()));
        }
    }

    private AppendEntriesRequest generateAppendEntriesRequest(Replica replica) throws Exception {
        ByteBuffer entries;
        long leftPosition = this.replicableStore.leftPosition();
        long startPosition = Math.max(replica.nextPosition(), leftPosition);
        if (startPosition >= this.replicableStore.rightPosition()) {
            return null;
        }
        try {
            entries = this.replicableStore.readEntryBuffer(startPosition, this.electionConfig.getMaxReplicateLength());
        }
        catch (Exception e) {
            logger.info("Partition group {}/node {} read entries from {} fail rollback to prev", new Object[]{this.topicPartitionGroup, this.localReplicaId, startPosition, e});
            long oldPosition = startPosition;
            startPosition = this.getPrevPosition(startPosition);
            replica.nextPosition(startPosition);
            logger.info("Partition group {}/node {} get prev position of {} return {}, left position is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, oldPosition, startPosition, leftPosition});
            entries = this.replicableStore.readEntryBuffer(startPosition, this.electionConfig.getMaxReplicateLength());
        }
        if (entries == null || !entries.hasRemaining()) {
            return null;
        }
        int entriesTerm = this.replicableStore.getEntryTerm(startPosition);
        long prevPosition = 0L;
        int prevTerm = 0;
        if (!replica.isMatch() && startPosition > leftPosition) {
            prevPosition = this.replicableStore.position(startPosition, -1);
            logger.info("Partition group {}/node {} generate append entries request, start position is {}, prev pos is {}, left pos is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, startPosition, prevPosition, leftPosition});
            prevTerm = this.replicableStore.getEntryTerm(prevPosition);
        }
        return AppendEntriesRequest.Build.create().partitionGroup(this.topicPartitionGroup).leader(this.leaderId).term(this.currentTerm).startPosition(startPosition).leftPosition(leftPosition).match(replica.isMatch()).commitPosition(this.replicableStore.commitPosition()).prevTerm(prevTerm).prevPosition(prevPosition).entriesTerm(entriesTerm).entries(entries).build();
    }

    private synchronized void processAppendEntriesResponse(AppendEntriesResponse response, Replica replica) {
        replica.lastAppendSuccessTime(SystemClock.now());
        if (!response.isSuccess()) {
            if (response.getNextPosition() == -1L) {
                replica.nextPosition(this.getPrevPosition(replica.nextPosition()));
            } else {
                replica.nextPosition(this.getPrevPosition(response.getNextPosition()));
            }
            return;
        }
        replica.writePosition(response.getWritePosition());
        replica.nextPosition(response.getNextPosition());
        replica.setMatch(true);
        if (this.transferee != -1 && replica.nextPosition() >= this.timeoutNowPosition) {
            this.sendTimeoutNowRequest(this.transferee);
        }
        this.getReplica(this.leaderId).writePosition(this.replicableStore.rightPosition());
        this.replicasWithoutLearners.sort((r1, r2) -> Long.compare(r2.writePosition(), r1.writePosition()));
        long commitPosition = this.replicasWithoutLearners.get(this.replicasWithoutLearners.size() / 2).writePosition();
        this.replicableStore.commit(commitPosition);
        if (null != this.brokerConfig && this.brokerConfig.getLogDetail(this.topicPartitionGroup.getTopic())) {
            this.replicas.forEach(r -> logger.info("Partition group {}/node {}", (Object)this.topicPartitionGroup, r));
            logger.info("Partition group {}/node {} commit position is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, this.replicableStore.commitPosition()});
        }
    }

    private void maybeReplicateConsumePos(Replica replica) {
        long now = SystemClock.now();
        if (now - replica.lastReplicateConsumePosTime() < (long)this.electionConfig.getReplicateConsumePosInterval()) {
            return;
        }
        replica.lastReplicateConsumePosTime(now);
        try {
            this.replicateExecutor.submit(() -> {
                try {
                    long replicateStartTime = SystemClock.now();
                    Map<ConsumePartition, Position> consumePositions = this.consume.getConsumePositionByGroup(TopicName.parse((String)this.topicPartitionGroup.getTopic()), this.topicPartitionGroup.getPartitionGroupId());
                    if (consumePositions == null) {
                        logger.debug("Partition group {}/node {} get consumer info return null", (Object)this.topicPartitionGroup, (Object)this.localReplicaId);
                        return;
                    }
                    ReplicateConsumePosRequest request = new ReplicateConsumePosRequest(consumePositions);
                    JoyQueueHeader header = new JoyQueueHeader(Direction.REQUEST, 49);
                    if (logger.isDebugEnabled() || this.electionConfig.getOutputConsumePos()) {
                        logger.debug("Partition group {}/node {} send consume position {} to node {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, consumePositions, replica.replicaId()});
                    }
                    this.sendCommand(replica.getAddress(), new Command((Header)header, (Object)request), this.electionConfig.getSendCommandTimeout(), new ReplicateConsumePosRequestCallback(replica));
                    long elapsed = SystemClock.now() - now;
                    if (elapsed > 5L) {
                        logger.info("Finished replicate consume position, topic partition group {}, total elapsed {}, process elapsed {} ", new Object[]{this.topicPartitionGroup.toString(), elapsed, SystemClock.now() - replicateStartTime});
                    }
                }
                catch (Exception e) {
                    logger.warn("Partition group {}/node {} send replicate consume pos message fail", new Object[]{this.topicPartitionGroup, this.localReplicaId, e});
                }
            });
        }
        catch (Exception e) {
            logger.warn("Partition group {}/node {} replicate consume position task failed", new Object[]{this.topicPartitionGroup, this.localReplicaId, e});
        }
    }

    public Command appendEntries(AppendEntriesRequest request) {
        long startPosition = request.getStartPosition();
        long nextPosition = request.getStartPosition();
        int entriesLength = request.getEntries().remaining();
        boolean success = true;
        logger.debug("Partition group {}/node {} receive append entries request {}, start position is {}, write position is {}, commit position is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, request, startPosition, this.replicableStore.rightPosition(), this.replicableStore.commitPosition()});
        try {
            if (this.state != ElectionNode.State.FOLLOWER) {
                logger.info("Partition group {}/node {} receive append entries request {}, state is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, request, this.state});
                success = false;
            } else {
                long startTimeUs = this.usTime();
                if (!this.matchPosition(request.getStartPosition(), request.getLeftPosition(), request.getPrevTerm(), request.getPrevPosition(), request.isMatch())) {
                    if (request.getStartPosition() > this.replicableStore.rightPosition()) {
                        logger.info("Partition group {}/node {} match position, position is {}, write position is {}, left position is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, request.getStartPosition(), this.replicableStore.rightPosition(), request.getLeftPosition()});
                        nextPosition = this.replicableStore.rightPosition() > request.getLeftPosition() ? this.replicableStore.rightPosition() : request.getLeftPosition();
                    } else {
                        nextPosition = -1L;
                    }
                    success = false;
                } else {
                    if (this.usTime() - startTimeUs > 300000L) {
                        logger.info("Partition group {}/node {} match position, position is {}, elapse {} us", new Object[]{this.topicPartitionGroup, this.localReplicaId, this.usTime() - startTimeUs});
                    }
                    if (request.getLeftPosition() == request.getStartPosition() && request.getLeftPosition() > this.replicableStore.leftPosition()) {
                        this.replicableStore.clear(request.getStartPosition());
                        logger.info("Partition group {}/node {} clear, position is {}, write position is {}, left position is {}, elapse {} us", new Object[]{this.topicPartitionGroup, this.localReplicaId, request.getStartPosition(), this.replicableStore.rightPosition(), request.getLeftPosition(), this.usTime() - startTimeUs});
                    } else if (request.getStartPosition() != this.replicableStore.rightPosition()) {
                        this.replicableStore.setRightPosition(request.getStartPosition());
                        logger.info("Partition group {}/node {} set right position, position is {}, write position is {}, left position is {}, elapse {} us", new Object[]{this.topicPartitionGroup, this.localReplicaId, request.getStartPosition(), this.replicableStore.rightPosition(), request.getLeftPosition(), this.usTime() - startTimeUs});
                    }
                    nextPosition = this.replicableStore.appendEntryBuffer(request.getEntries());
                    if (logger.isDebugEnabled() || this.usTime() - startTimeUs > 300000L) {
                        logger.info("Partition group {}/node {}, append entries from {}, position is {}, entry length is {}, commit position is {}, elapse {} us", new Object[]{this.topicPartitionGroup, this.localReplicaId, request.getLeaderId(), startPosition, entriesLength, request.getCommitPosition(), this.usTime() - startTimeUs});
                    }
                    this.brokerMonitor.onAppendReplicateMessage(this.topicPartitionGroup.getTopic(), this.topicPartitionGroup.getPartitionGroupId(), 1L, request.getEntriesLength(), this.usTime() - startTimeUs);
                    this.replicableStore.commit(request.getCommitPosition());
                }
            }
        }
        catch (TimeoutException te) {
            logger.warn("Partition group {}/node {} append entries to position {} timeout, entries length is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, startPosition, entriesLength, te});
            success = false;
            nextPosition = startPosition;
        }
        catch (Throwable t) {
            logger.warn("Partition group {}/node {} append entries to position {} failed, write position is {}\uff0c entries length is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, startPosition, this.replicableStore.rightPosition(), entriesLength, t});
            success = false;
            nextPosition = -1L;
        }
        AppendEntriesResponse response = AppendEntriesResponse.Build.create().topicPartitionGroup(this.topicPartitionGroup).term(this.currentTerm).writePosition(this.replicableStore.rightPosition()).nextPosition(nextPosition).replicaId(this.localReplicaId).success(success).entriesTerm(request.getEntriesTerm()).build();
        return new Command((Header)new JoyQueueHeader(Direction.RESPONSE, -45), (Object)response);
    }

    private boolean matchPosition(long startPosition, long leftPosition, int prevTerm, long prevPosition, boolean isMatch) {
        boolean match = false;
        int localPrevTerm = -1;
        if (startPosition == leftPosition) {
            logger.info("Partition group {}/node {} match position start position {} equals left position", new Object[]{this.topicPartitionGroup, this.localReplicaId, startPosition});
            return true;
        }
        if (startPosition > this.replicableStore.rightPosition()) {
            logger.info("Partition group {}/node {} match position start position {} bigger then right position {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, startPosition, this.replicableStore.rightPosition()});
            return false;
        }
        if (isMatch) {
            return true;
        }
        if (prevPosition > this.replicableStore.leftPosition()) {
            try {
                localPrevTerm = this.replicableStore.getEntryTerm(prevPosition);
            }
            catch (Exception e) {
                logger.info("Partition group {}/node {} match position get entry term fail, start position is {}, prev position is {}, left position is {}, right position is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, startPosition, prevPosition, leftPosition, this.replicableStore.rightPosition(), e});
            }
        }
        logger.info("Partition group {}/node {} match prev position and term, position is {}, left position is {}, prev position is {}, prev term is {},  local prev term is {}, right position is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, startPosition, leftPosition, prevPosition, prevTerm, localPrevTerm, this.replicableStore.rightPosition()});
        if (prevTerm == localPrevTerm) {
            match = true;
        }
        return match;
    }

    private long getPrevPosition(long position) {
        try {
            return this.replicableStore.position(position, -1);
        }
        catch (Throwable t) {
            long leftPosition = this.replicableStore.leftPosition();
            logger.warn("Partition group {}/node {} get previous position of position {} fail, return left position {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, position, leftPosition});
            return leftPosition;
        }
    }

    public int findTheNextCandidate(int leaderId) {
        long maxPosition = -1L;
        int candidateId = -1;
        for (Replica replica : this.replicas) {
            if (replica.replicaId() == leaderId || replica.nextPosition() <= maxPosition) continue;
            maxPosition = replica.nextPosition();
            candidateId = replica.replicaId();
        }
        return candidateId;
    }

    public void transferLeadershipTo(int transferee, long logPosition) throws TransportException {
        this.transferee = transferee;
        logger.info("Partition group {}/node {} transfer leadership to {}, log position is {}, transferee next position is {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, transferee, logPosition, this.getReplica(transferee).nextPosition()});
        if (this.getReplica(transferee).nextPosition() >= logPosition) {
            this.sendTimeoutNowRequest(transferee);
        }
        this.timeoutNowPosition = logPosition;
    }

    public void stopTransferLeadership() {
        this.transferee = -1;
        this.timeoutNowPosition = 0L;
    }

    private void sendTimeoutNowRequest(int transferee) throws TransportException {
        logger.info("Partition group {}/node {} send timeout now request to {}", new Object[]{this.topicPartitionGroup, this.localReplicaId, transferee});
        TimeoutNowRequest request = new TimeoutNowRequest(this.topicPartitionGroup, this.currentTerm);
        JoyQueueHeader header = new JoyQueueHeader(Direction.REQUEST, 46);
        this.sendCommand(this.getReplica(transferee).getAddress(), new Command((Header)header, (Object)request), this.electionConfig.getSendCommandTimeout(), new TimeoutNowRequestCallback());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCommand(String address, Command command, int timeout, CommandCallback callback) throws TransportException {
        ReplicationTransportSession transport = (ReplicationTransportSession)this.sessions.get(address);
        if (transport == null) {
            ConcurrentMap<String, ReplicationTransportSession> concurrentMap = this.sessions;
            synchronized (concurrentMap) {
                transport = (ReplicationTransportSession)this.sessions.get(address);
                if (transport == null) {
                    logger.info("Replication manager create transport of {}", (Object)address);
                    transport = new ReplicationTransportSession(address, this.transportClient);
                    this.sessions.put(address, transport);
                }
            }
        }
        transport.sendCommand(command, timeout, callback);
    }

    private long usTime() {
        return System.nanoTime() / 1000L;
    }

    private class DelayedCommand
    implements Delayed {
        private long startTimeNs = System.nanoTime();
        private long delayTimeNs;
        private int replicaId;

        DelayedCommand(long delayTimeNs, int replicaId) {
            this.delayTimeNs = delayTimeNs;
            this.replicaId = replicaId;
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            return unit.convert(this.remainTimeNs(), TimeUnit.NANOSECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed another) {
            if (another instanceof DelayedCommand) {
                return Long.compare(this.remainTimeNs(), ((DelayedCommand)another).remainTimeNs());
            }
            return 0;
        }

        private long remainTimeNs() {
            return this.delayTimeNs - (System.nanoTime() - this.startTimeNs);
        }

        int replicaId() {
            return this.replicaId;
        }
    }

    private class TimeoutNowRequestCallback
    implements CommandCallback {
        private TimeoutNowRequestCallback() {
        }

        public void onSuccess(Command request, Command responseCommand) {
            if (!(responseCommand.getPayload() instanceof TimeoutNowResponse)) {
                return;
            }
            TimeoutNowResponse response = (TimeoutNowResponse)((Object)responseCommand.getPayload());
            logger.info("Partition group {}/node {} timeout now request receive response, success is {}, response term is {}", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, response.isSuccess(), response.getTerm()});
            if (response.getTerm() > ReplicaGroup.this.currentTerm) {
                ReplicaGroup.this.leaderElection.stepDown(response.getTerm());
            }
            ReplicaGroup.this.transferee = -1;
            ReplicaGroup.this.timeoutNowPosition = 0L;
        }

        public void onException(Command request, Throwable cause) {
            logger.info("Partition group {}/node {} timeout now request fail", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, cause});
            ReplicaGroup.this.transferee = -1;
            ReplicaGroup.this.timeoutNowPosition = 0L;
        }
    }

    private class ReplicateConsumePosRequestCallback
    implements CommandCallback {
        private Replica replica;

        ReplicateConsumePosRequestCallback(Replica replica) {
            this.replica = replica;
        }

        public void onSuccess(Command request, Command responseCommand) {
            if (!(responseCommand.getPayload() instanceof ReplicateConsumePosResponse)) {
                return;
            }
            ReplicateConsumePosResponse response = (ReplicateConsumePosResponse)((Object)responseCommand.getPayload());
            if (!response.isSuccess()) {
                logger.info("Partition group {}/node {} replicate consume pos to {} fail", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, this.replica.replicaId()});
            }
        }

        public void onException(Command request, Throwable cause) {
            logger.info("Partition group {}/node {} replicate consume pos to {} fail", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, this.replica.replicaId(), cause});
        }
    }

    private class AppendEntriesRequestCallback
    implements CommandCallback {
        private Replica replica;
        private long startTimeUs;
        private int entriesLength;

        AppendEntriesRequestCallback(Replica replica, long startTimeUs, int entriesLength) {
            this.replica = replica;
            this.startTimeUs = startTimeUs;
            this.entriesLength = entriesLength;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess(Command request, Command response) {
            try {
                if (!(request.getPayload() instanceof AppendEntriesRequest) || !(response.getPayload() instanceof AppendEntriesResponse)) {
                    return;
                }
                AppendEntriesRequest appendEntriesRequest = (AppendEntriesRequest)((Object)request.getPayload());
                AppendEntriesResponse appendEntriesResponse = (AppendEntriesResponse)((Object)response.getPayload());
                if (logger.isDebugEnabled() || ReplicaGroup.this.usTime() - this.startTimeUs > 300000L) {
                    logger.info("Partition group {}/node {} receive append entries response from {}, success is {}, next position is {}, write position is {}, elapse {} us", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, this.replica.replicaId(), appendEntriesResponse.isSuccess(), appendEntriesResponse.getNextPosition(), appendEntriesResponse.getWritePosition(), ReplicaGroup.this.usTime() - this.startTimeUs});
                }
                if (appendEntriesRequest.getTerm() != ReplicaGroup.this.currentTerm) {
                    logger.info("Partition group {}/node {} append entries request term {} not equals current term {}", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, appendEntriesRequest.getTerm(), ReplicaGroup.this.currentTerm});
                    return;
                }
                if (appendEntriesResponse.getTerm() > ReplicaGroup.this.currentTerm) {
                    logger.info("Partition group {}/node {} append entries response term {} not equals current term {}", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, appendEntriesResponse.getTerm(), ReplicaGroup.this.currentTerm});
                    ReplicaGroup.this.leaderElection.stepDown(appendEntriesResponse.getTerm());
                    return;
                }
                ReplicaGroup.this.processAppendEntriesResponse(appendEntriesResponse, this.replica);
                ReplicaGroup.this.brokerMonitor.onReplicateMessage(ReplicaGroup.this.topicPartitionGroup.getTopic(), ReplicaGroup.this.topicPartitionGroup.getPartitionGroupId(), 1L, this.entriesLength, ReplicaGroup.this.usTime() - this.startTimeUs);
            }
            catch (Exception e) {
                logger.info("Partition group {}/node {} process append entries reponse fail", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, e});
            }
            finally {
                ReplicaGroup.this.replicateResponseQueue.put(new DelayedCommand(0L, this.replica.replicaId()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onException(Command request, Throwable cause) {
            try {
                if (!(request.getPayload() instanceof AppendEntriesRequest)) {
                    TopicPartitionGroup tpg = ReplicaGroup.this.topicPartitionGroup;
                    logger.error("Replicate failure. topicPartitionGroup {}", (Object)(tpg == null ? "null" : tpg.toString()), (Object)cause);
                    return;
                }
                AppendEntriesRequest appendEntriesRequest = (AppendEntriesRequest)((Object)request.getPayload());
                logger.error("Partition group {}/node {} send append entries request to {} failed, position is {}, current term is {}", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, this.replica.replicaId(), appendEntriesRequest.getStartPosition(), ReplicaGroup.this.currentTerm, cause});
            }
            catch (Exception e) {
                logger.warn("Partition group {}/node {} send append entries onException fail, request is {}", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, request, e});
            }
            finally {
                ReplicaGroup.this.replicateResponseQueue.put(new DelayedCommand(1000000000L, this.replica.replicaId()));
            }
        }
    }

    class ReplicateThread
    extends Thread {
        private ReplicateThread(String name) {
            super(name);
        }

        @Override
        public void run() {
            ReplicaGroup.this.initResponseQueue();
            while (true) {
                try {
                    while (true) {
                        if (!ReplicaGroup.this.isStarted() || ReplicaGroup.this.state != ElectionNode.State.LEADER && ReplicaGroup.this.state != ElectionNode.State.TRANSFERRING) {
                            Thread.sleep(100L);
                            continue;
                        }
                        if (ReplicaGroup.this.neednotReplicate()) {
                            return;
                        }
                        DelayedCommand command = (DelayedCommand)ReplicaGroup.this.replicateResponseQueue.take();
                        if (command.replicaId() == ReplicaGroup.this.localReplicaId) {
                            ReplicaGroup.this.replicateLocal();
                            continue;
                        }
                        if (!ReplicaGroup.this.replicas.contains(ReplicaGroup.this.getReplica(command.replicaId()))) {
                            logger.info("Partition group {}/node {} not contain this node {}", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, command.replicaId()});
                            continue;
                        }
                        ReplicaGroup.this.replicateMessage(ReplicaGroup.this.getReplica(command.replicaId()));
                        ReplicaGroup.this.maybeReplicateConsumePos(ReplicaGroup.this.getReplica(command.replicaId()));
                    }
                }
                catch (InterruptedException ie) {
                    logger.info("Partition group {}/node {} replicate interrupted", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, ie});
                }
                catch (Throwable t) {
                    logger.warn("Partition group {}/node {} replicate fail", new Object[]{ReplicaGroup.this.topicPartitionGroup, ReplicaGroup.this.localReplicaId, t});
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }
    }
}

