/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.replication;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.joyqueue.broker.config.BrokerConfig;
import org.joyqueue.broker.consumer.Consume;
import org.joyqueue.broker.election.DefaultElectionNode;
import org.joyqueue.broker.election.ElectionConfig;
import org.joyqueue.broker.election.ElectionException;
import org.joyqueue.broker.election.TopicPartitionGroup;
import org.joyqueue.broker.monitor.BrokerMonitor;
import org.joyqueue.broker.network.support.BrokerTransportClientFactory;
import org.joyqueue.broker.replication.ReplicaGroup;
import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.config.ClientConfig;
import org.joyqueue.store.StoreService;
import org.joyqueue.store.replication.ReplicableStore;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.lang.Close;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationManager
extends Service {
    private static Logger logger = LoggerFactory.getLogger(ReplicationManager.class);
    private ConcurrentHashMap<TopicPartitionGroup, ReplicaGroup> replicaGroups;
    private ElectionConfig electionConfig;
    private BrokerConfig brokerConfig;
    private final ConcurrentHashMap<String, Transport> sessions = new ConcurrentHashMap();
    private StoreService storeService;
    private Consume consume;
    private TransportClient transportClient;
    private ExecutorService replicateExecutor;
    private ScheduledExecutorService replicateTimerExecutor;
    private BlockingDeque replicateQueue;

    public ReplicationManager(ElectionConfig electionConfig, BrokerConfig brokerConfig, StoreService storeService, Consume consume, BrokerMonitor brokerMonitor) {
        Preconditions.checkArgument((electionConfig != null ? 1 : 0) != 0, (Object)"election config is null");
        Preconditions.checkArgument((storeService != null ? 1 : 0) != 0, (Object)"store service is null");
        Preconditions.checkArgument((consume != null ? 1 : 0) != 0, (Object)"consume is null");
        this.electionConfig = electionConfig;
        this.brokerConfig = brokerConfig;
        this.storeService = storeService;
        this.consume = consume;
    }

    public void doStart() throws Exception {
        super.doStart();
        this.replicaGroups = new ConcurrentHashMap();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setIoThreadName("joyqueue-Replication-IO-EventLoop");
        clientConfig.setMaxAsync(1000);
        clientConfig.setIoThread(32);
        clientConfig.setSocketBufferSize(0x100000);
        clientConfig.setConnectionTimeout(300);
        clientConfig.getRetryPolicy().setRetryDelay(Integer.valueOf(60000));
        this.transportClient = new BrokerTransportClientFactory().create(clientConfig);
        this.transportClient.start();
        this.replicateQueue = new LinkedBlockingDeque(this.electionConfig.getCommandQueueSize());
        this.replicateExecutor = new ThreadPoolExecutor(this.electionConfig.getReplicateThreadNumMin(), this.electionConfig.getReplicateThreadNumMax(), 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)this.replicateQueue, (ThreadFactory)new NamedThreadFactory("Replicate-sendCommand"));
        this.replicateTimerExecutor = Executors.newScheduledThreadPool(this.electionConfig.getTimerScheduleThreadNum());
        this.replicateTimerExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    ConcurrentHashMap replicaGroups = ReplicationManager.this.replicaGroups;
                    int replicaGroupCount = 0;
                    int replicaLeaderCount = 0;
                    for (ReplicaGroup replicaGroup : replicaGroups.values()) {
                        ++replicaGroupCount;
                        if (!replicaGroup.isLeader()) continue;
                        ++replicaLeaderCount;
                    }
                    logger.info("ReplicationManager, managed replica group count {} ,leader count {} , replicate queue capacity is {}, current size is {}", new Object[]{replicaGroupCount, replicaLeaderCount, ReplicationManager.this.electionConfig.getCommandQueueSize(), ReplicationManager.this.replicateQueue.size()});
                }
                catch (Throwable th) {
                    logger.warn("ReplicateManger schedule error.", th);
                }
            }
        }, 30L, 30L, TimeUnit.SECONDS);
    }

    public void doStop() {
        Close.close((LifeCycle)this.transportClient);
        Close.close((ExecutorService)this.replicateExecutor);
        super.doStop();
    }

    public synchronized ReplicaGroup createReplicaGroup(String topic, int partitionGroup, List<DefaultElectionNode> allNodes, Set<Integer> learners, int localReplicaId, int leaderId, BrokerMonitor brokerMonitor) throws ElectionException {
        ReplicableStore replicableStore;
        TopicPartitionGroup topicPartitionGroup = new TopicPartitionGroup(topic, partitionGroup);
        ReplicaGroup replicaGroup = this.replicaGroups.get(topicPartitionGroup);
        if (replicaGroup != null) {
            logger.warn("Create replica group for topic {} partition group {} failed, replication group is not null", (Object)topic, (Object)partitionGroup);
            this.removeReplicaGroup(topic, partitionGroup);
        }
        if ((replicableStore = this.storeService.getReplicableStore(topic, partitionGroup)) == null) {
            logger.info("Create replica group for topic {} partition group {} failed, replicable store is null", (Object)topic, (Object)partitionGroup);
            throw new ElectionException(String.format("Create Replica group for topic %s partition group %d failed, replicable store is null", topic, partitionGroup));
        }
        replicaGroup = new ReplicaGroup(topicPartitionGroup, this, replicableStore, this.electionConfig, this.brokerConfig, this.consume, this.replicateExecutor, brokerMonitor, allNodes, learners, localReplicaId, leaderId, this.transportClient);
        try {
            replicaGroup.start();
        }
        catch (Exception e) {
            throw new ElectionException("Create replica group fail" + e);
        }
        this.replicaGroups.put(topicPartitionGroup, replicaGroup);
        return replicaGroup;
    }

    public synchronized void removeReplicaGroup(String topic, int partitionGroup) {
        TopicPartitionGroup topicPartitionGroup = new TopicPartitionGroup(topic, partitionGroup);
        ReplicaGroup replicaGroup = this.replicaGroups.get(topicPartitionGroup);
        if (replicaGroup == null) {
            logger.info("Remove replica group of topic {} partition group {}, replication group is null", (Object)topic, (Object)partitionGroup);
            return;
        }
        replicaGroup.stop();
        this.replicaGroups.remove(topicPartitionGroup);
    }

    public ReplicaGroup getReplicaGroup(String topic, int partitionGroup) {
        ReplicaGroup replicaGroup = this.replicaGroups.get(new TopicPartitionGroup(topic, partitionGroup));
        if (replicaGroup == null) {
            logger.info("Get replica group of topic {} partition group {}, replication group is null", (Object)topic, (Object)partitionGroup);
        }
        return replicaGroup;
    }
}

