/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.replication;

import org.joyqueue.network.transport.Transport;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.command.Command;
import org.joyqueue.network.transport.command.CommandCallback;
import org.joyqueue.network.transport.exception.TransportException;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationTransportSession {
    protected static final Logger logger = LoggerFactory.getLogger(ReplicationTransportSession.class);
    private static final long RECONNECT_INTERVAL = 60000L;
    private TransportClient transportClient;
    private Transport transport;
    private String address;
    private volatile long lastReconnect;

    public ReplicationTransportSession(String address, TransportClient transportClient) {
        this.address = address;
        this.transportClient = transportClient;
        this.transport = this.initTransport();
    }

    public void start() throws TransportException {
        try {
            this.transportClient.start();
        }
        catch (TransportException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TransportException.UnknownException("", (Throwable)e);
        }
    }

    public void sendCommand(Command request, int timeout, CommandCallback callback) {
        if (this.transport == null) {
            if (SystemClock.now() - this.lastReconnect < 60000L) {
                callback.onException(request, (Throwable)new TransportException.ConnectionException(this.address));
                return;
            }
            this.transport = this.initTransport();
            if (this.transport == null) {
                callback.onException(request, (Throwable)new TransportException.ConnectionException(this.address));
                return;
            }
        }
        this.transport.async(request, (long)timeout, callback);
    }

    public void stop() {
        if (this.transport != null) {
            this.transport.stop();
        }
    }

    protected Transport initTransport() {
        try {
            Transport transport = this.transportClient.createTransport(this.address);
            return transport;
        }
        catch (Exception e) {
            logger.error("create transport session exception, address: {}", (Object)this.address, (Object)e);
            Transport transport = null;
            return transport;
        }
        finally {
            this.lastReconnect = SystemClock.now();
        }
    }
}

