/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.retry;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.jd.laf.extension.ExtensionManager;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.Plugins;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.limit.RateLimiter;
import org.joyqueue.broker.monitor.BrokerMonitor;
import org.joyqueue.broker.network.support.BrokerTransportClientFactory;
import org.joyqueue.broker.retry.BrokerRetryRateLimiterManager;
import org.joyqueue.broker.retry.RetryRateLimiter;
import org.joyqueue.config.BrokerConfigKey;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.Consumer;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.EventType;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.monitor.PointTracer;
import org.joyqueue.monitor.TraceStat;
import org.joyqueue.network.session.Joint;
import org.joyqueue.network.transport.TransportClient;
import org.joyqueue.network.transport.config.ClientConfig;
import org.joyqueue.network.transport.config.TransportConfigSupport;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.event.UpdateBrokerEvent;
import org.joyqueue.server.retry.NullMessageRetry;
import org.joyqueue.server.retry.api.MessageRetry;
import org.joyqueue.server.retry.api.RetryPolicyProvider;
import org.joyqueue.server.retry.model.RetryMessageModel;
import org.joyqueue.server.retry.remote.RemoteMessageRetry;
import org.joyqueue.server.retry.remote.RemoteRetryProvider;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.Property;
import org.joyqueue.toolkit.config.PropertyDef;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.retry.RetryPolicy;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerRetryManager
extends Service
implements MessageRetry<Long>,
BrokerContextAware {
    private static final Logger logger = LoggerFactory.getLogger(BrokerRetryManager.class);
    private MessageRetry delegate;
    private EventListener eventListener = new BrokerRetryEventListener();
    private volatile String retryType;
    private RetryPolicyProvider retryPolicyProvider;
    private RemoteRetryProvider remoteRetryProvider;
    private NameService nameService;
    private ClusterManager clusterManager;
    private PropertySupplier propertySupplier;
    private RetryRateLimiter rateLimiterManager;
    private BrokerMonitor brokerMonitor;
    private PointTracer tracer;

    public BrokerRetryManager(BrokerContext brokerContext) {
        this.setBrokerContext(brokerContext);
        this.rateLimiterManager = new BrokerRetryRateLimiterManager(brokerContext);
    }

    protected void validate() throws Exception {
        super.validate();
        if (this.retryPolicyProvider == null) {
            this.retryPolicyProvider = new RetryPolicyProviderImpl();
        }
        if (this.remoteRetryProvider == null) {
            this.remoteRetryProvider = new RemoteRetryProvider(){

                public Set<String> getUrls() {
                    List<Broker> brokers = BrokerRetryManager.this.clusterManager.getLocalRetryBroker();
                    logger.info("broker list:{}", (Object)Arrays.toString(brokers.toArray()));
                    HashSet<String> urlSet = new HashSet<String>();
                    for (Broker broker : brokers) {
                        urlSet.add(broker.getIp() + ":" + broker.getBackEndPort());
                    }
                    return urlSet;
                }

                public TransportClient createTransportClient() {
                    ClientConfig clientConfig = TransportConfigSupport.buildClientConfig((PropertySupplier)BrokerRetryManager.this.propertySupplier, (String)"retry.remote.client");
                    clientConfig.setIoThreadName("joyqueue-retry-io-eventLoop");
                    return new BrokerTransportClientFactory().create(clientConfig);
                }
            };
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.clusterManager.addListener((EventListener<MetaEvent>)this.eventListener);
        this.clusterManager.addListener(this.rateLimiterManager);
        this.retryType = this.clusterManager.getBroker().getRetryType();
        this.delegate = this.loadRetryManager(this.retryType);
    }

    public void setRetryPolicyProvider(RetryPolicyProvider retryPolicyProvider) {
        this.retryPolicyProvider = retryPolicyProvider;
    }

    public void addRetry(List<RetryMessageModel> retryMessageModelList) throws JoyQueueException {
        if (CollectionUtils.isEmpty(retryMessageModelList)) {
            return;
        }
        Set<Joint> consumers = this.retryConsumers(retryMessageModelList);
        if (this.retryTokenAvailable(consumers)) {
            RetryMessageModel retryMessageModel = retryMessageModelList.get(0);
            TraceStat totalRetryTrace = this.tracer.begin("BrokerRetryManager.addRetry");
            TraceStat appRetryTrace = this.tracer.begin(String.format("BrokerRetryManager.addRetry.%s.%s", retryMessageModel.getApp().replace(".", "_"), retryMessageModel.getTopic()));
            try {
                long startTime = SystemClock.now();
                this.delegate.addRetry(retryMessageModelList);
                this.brokerMonitor.onAddRetry(retryMessageModel.getTopic(), retryMessageModel.getApp(), retryMessageModelList.size(), SystemClock.now() - startTime);
                this.tracer.end(totalRetryTrace);
                this.tracer.end(appRetryTrace);
            }
            catch (Exception e) {
                this.tracer.error(totalRetryTrace);
                this.tracer.error(appRetryTrace);
                throw e;
            }
        } else {
            throw new JoyQueueException(JoyQueueCode.RETRY_TOKEN_LIMIT, new Object[0]);
        }
    }

    public boolean retryTokenAvailable(Set<Joint> consumers) {
        for (Joint consumer : consumers) {
            RateLimiter rateLimiter = this.rateLimiterManager.getOrCreate(consumer.getTopic(), consumer.getApp());
            if (rateLimiter != null && !rateLimiter.tryAcquireTps()) continue;
            return true;
        }
        return false;
    }

    public Set<Joint> retryConsumers(List<RetryMessageModel> retryMessageModelList) {
        HashSet<Joint> consumers = new HashSet<Joint>(retryMessageModelList.size());
        for (RetryMessageModel m : retryMessageModelList) {
            consumers.add(new Joint(m.getTopic(), m.getApp()));
        }
        return consumers;
    }

    public void retrySuccess(String topic, String app, Long[] messageIds) throws JoyQueueException {
        if (messageIds == null) {
            return;
        }
        this.delegate.retrySuccess(topic, app, (Object[])messageIds);
        this.brokerMonitor.onRetrySuccess(topic, app, messageIds.length);
    }

    public void retryError(String topic, String app, Long[] messageIds) throws JoyQueueException {
        if (messageIds == null) {
            return;
        }
        this.delegate.retryError(topic, app, (Object[])messageIds);
        this.brokerMonitor.onRetryFailure(topic, app, messageIds.length);
    }

    public void retryExpire(String topic, String app, Long[] messageIds) throws JoyQueueException {
        this.delegate.retryExpire(topic, app, (Object[])messageIds);
    }

    public List<RetryMessageModel> getRetry(String topic, String app, short count, long startId) throws JoyQueueException {
        return this.delegate.getRetry(topic, app, count, startId);
    }

    public int countRetry(String topic, String app) throws JoyQueueException {
        return this.delegate.countRetry(topic, app);
    }

    private MessageRetry loadRetryManager(String type) throws Exception {
        boolean retryEnable;
        Property retryEnabledProperty = this.propertySupplier.getProperty("retry.enable");
        boolean bl = retryEnable = null == retryEnabledProperty ? false : retryEnabledProperty.getBoolean(Boolean.valueOf(false));
        Object messageRetry = !retryEnable ? new NullMessageRetry() : (type.equals("RemoteRetry") ? new RemoteMessageRetry(this.remoteRetryProvider) : (MessageRetry)ExtensionManager.getOrLoadExtension(MessageRetry.class, (Object)type));
        if (messageRetry == null) {
            throw new RuntimeException("No such implementation found." + type);
        }
        messageRetry.setSupplier(this.propertySupplier);
        messageRetry.setRetryPolicyProvider(this.retryPolicyProvider);
        messageRetry.start();
        return messageRetry;
    }

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        this.nameService = brokerContext.getNameService();
        this.clusterManager = brokerContext.getClusterManager();
        this.propertySupplier = brokerContext.getPropertySupplier();
        this.brokerMonitor = brokerContext.getBrokerMonitor();
        this.tracer = (PointTracer)Plugins.TRACERERVICE.get(PropertySupplier.getValue((PropertySupplier)this.propertySupplier, (PropertyDef)BrokerConfigKey.TRACER_TYPE));
    }

    public void setSupplier(PropertySupplier supplier) {
        this.propertySupplier = supplier;
    }

    protected class BrokerRetryEventListener
    implements EventListener<MetaEvent> {
        protected BrokerRetryEventListener() {
        }

        public void onEvent(MetaEvent event) {
            try {
                if (event.getEventType() == EventType.UPDATE_BROKER) {
                    MessageRetry messageRetry;
                    String type;
                    logger.info("listen update broker event.");
                    UpdateBrokerEvent updateBrokerEvent = (UpdateBrokerEvent)event;
                    Broker broker = updateBrokerEvent.getNewBroker();
                    String string = type = broker != null ? broker.getRetryType() : null;
                    if (type != null && !type.equals(BrokerRetryManager.this.retryType) && (messageRetry = BrokerRetryManager.this.loadRetryManager(type)) != null) {
                        MessageRetry pre = BrokerRetryManager.this.delegate;
                        if (pre != null) {
                            pre.stop();
                        }
                        BrokerRetryManager.this.delegate = messageRetry;
                    }
                    BrokerRetryManager.this.retryType = type;
                    logger.info("Broker Retry Mode is : {}", (Object)BrokerRetryManager.this.retryType);
                }
            }
            catch (Exception e) {
                logger.error("process broker retry event error.", (Throwable)e);
            }
        }
    }

    class RetryPolicyProviderImpl
    implements RetryPolicyProvider {
        private final Cache<String, RetryPolicy> cache = CacheBuilder.newBuilder().maximumSize(1000000L).expireAfterWrite(1L, TimeUnit.MINUTES).concurrencyLevel(Runtime.getRuntime().availableProcessors()).recordStats().build();

        RetryPolicyProviderImpl() {
        }

        public RetryPolicy getPolicy(TopicName topic, String app) {
            String cacheKey = this.getKey(topic, app);
            RetryPolicy retryPolicy = (RetryPolicy)this.cache.getIfPresent((Object)cacheKey);
            if (retryPolicy == null) {
                Consumer consumerByTopicAndApp = BrokerRetryManager.this.nameService.getConsumerByTopicAndApp(topic, app);
                if (consumerByTopicAndApp == null) {
                    logger.debug("nameService.getConsumerByTopicAndApp is null by topic:[{}], app:[{}]", (Object)topic, (Object)app);
                    retryPolicy = new RetryPolicy();
                    this.cache.put((Object)cacheKey, (Object)retryPolicy);
                    return retryPolicy;
                }
                retryPolicy = consumerByTopicAndApp.getRetryPolicy();
                if (retryPolicy == null) {
                    logger.debug("consumerByTopicAndApp.getRetryPolicy() is null by topic:[{}], app:[{}]", (Object)topic, (Object)app);
                    retryPolicy = new RetryPolicy();
                    this.cache.put((Object)cacheKey, (Object)retryPolicy);
                    return retryPolicy;
                }
                logger.debug("Get RetryPolicy:[{}] by topic:[{}], app:[{}], ", new Object[]{retryPolicy.toString(), topic.getFullName(), app});
                this.cache.put((Object)cacheKey, (Object)retryPolicy);
                return retryPolicy;
            }
            return retryPolicy;
        }

        private String getKey(TopicName topic, String app) {
            return topic.getFullName() + ":" + app;
        }
    }
}

