/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.retry;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.consumer.ConsumeConfig;
import org.joyqueue.broker.consumer.ConsumeConfigKey;
import org.joyqueue.broker.limit.RateLimiter;
import org.joyqueue.broker.limit.support.DefaultRateLimiter;
import org.joyqueue.broker.retry.RetryRateLimiter;
import org.joyqueue.domain.Config;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.nsr.event.RemoveConfigEvent;
import org.joyqueue.nsr.event.RemoveConsumerEvent;
import org.joyqueue.nsr.event.RemoveTopicEvent;
import org.joyqueue.nsr.event.UpdateConfigEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerRetryRateLimiterManager
implements RetryRateLimiter {
    protected static final Logger LOG = LoggerFactory.getLogger(BrokerRetryRateLimiterManager.class);
    private ClusterManager clusterManager;
    private ConsumeConfig consumeConfig;
    private ConcurrentMap<String, ConcurrentMap<String, RateLimiter>> retryRateLimiters = Maps.newConcurrentMap();

    public BrokerRetryRateLimiterManager(BrokerContext context) {
        this.clusterManager = context.getClusterManager();
        this.clusterManager.addListener(this);
        this.consumeConfig = new ConsumeConfig(context != null ? context.getPropertySupplier() : null);
    }

    @Override
    public RateLimiter getOrCreate(String topic, String app) {
        int tps;
        RateLimiter consumerRetryRateLimiter;
        ConcurrentMap old;
        ConcurrentMap<String, RateLimiter> topicRateLimiters = (ConcurrentHashMap)this.retryRateLimiters.get(topic);
        if (topicRateLimiters == null && (old = (ConcurrentMap)this.retryRateLimiters.putIfAbsent(topic, topicRateLimiters = new ConcurrentHashMap())) != null) {
            topicRateLimiters = old;
        }
        if ((consumerRetryRateLimiter = (RateLimiter)topicRateLimiters.get(app)) == null && (tps = this.consumerRetryRate(topic, app)) > 0) {
            consumerRetryRateLimiter = new DefaultRateLimiter(tps);
            RateLimiter oldRateLimiter = topicRateLimiters.putIfAbsent(app, consumerRetryRateLimiter);
            if (oldRateLimiter != null) {
                consumerRetryRateLimiter = oldRateLimiter;
            } else {
                LOG.info("New rate limiter for {},{},{}", new Object[]{topic, app, tps});
            }
        }
        return consumerRetryRateLimiter;
    }

    public int consumerRetryRate(String topic, String app) {
        int retryRate = this.consumeConfig.getRetryRate(topic, app);
        if (retryRate <= 0) {
            retryRate = this.consumeConfig.getRetryRate();
        }
        return retryRate;
    }

    public void onEvent(MetaEvent event) {
        switch (event.getEventType()) {
            case UPDATE_CONFIG: {
                UpdateConfigEvent updateConfigEvent = (UpdateConfigEvent)event;
                Config config = updateConfigEvent.getNewConfig();
                this.cleanRateLimiter(config);
                break;
            }
            case REMOVE_CONFIG: {
                RemoveConfigEvent removeConfigEvent = (RemoveConfigEvent)event;
                Config config = removeConfigEvent.getConfig();
                this.cleanRateLimiter(config);
                break;
            }
            case REMOVE_TOPIC: {
                RemoveTopicEvent topicEvent = (RemoveTopicEvent)event;
                this.cleanRateLimiter(topicEvent.getTopic().getName().getFullName(), null);
                break;
            }
            case REMOVE_CONSUMER: {
                RemoveConsumerEvent removeConsumerEvent = (RemoveConsumerEvent)event;
                this.cleanRateLimiter(removeConsumerEvent.getTopic().getFullName(), removeConsumerEvent.getConsumer().getApp());
            }
        }
    }

    public void cleanRateLimiter(Config config) {
        String[] keys;
        String configKey = config.getKey();
        if (StringUtils.isBlank((CharSequence)configKey)) {
            return;
        }
        if (configKey.equals(ConsumeConfigKey.RETRY_RATE.getName())) {
            this.retryRateLimiters.clear();
        } else if (configKey.startsWith(ConsumeConfigKey.RETRY_RATE_PREFIX.getName()) && (keys = configKey.split("\\.")).length == 4) {
            String topic = keys[2];
            String app = keys[3];
            if (topic != null && app != null) {
                this.cleanRateLimiter(topic, app);
            }
        }
    }

    public void cleanRateLimiter(String topic, String app) {
        if (app == null) {
            this.retryRateLimiters.remove(topic);
        } else {
            Map rateLimiters = (Map)this.retryRateLimiters.get(topic);
            if (rateLimiters != null) {
                rateLimiters.remove(app);
            }
        }
    }
}

