/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.retry;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.joyqueue.network.session.Joint;
import org.joyqueue.toolkit.service.Service;

public class RetryProbability
extends Service {
    private int maxProbability = 200;
    private int minProbability = 5;
    private int defaultProbability = 5;
    private final Map<Joint, Integer> probabilityCache = new ConcurrentHashMap<Joint, Integer>();

    public RetryProbability() {
    }

    public RetryProbability(int maxProbability, int minProbability, int defaultProbability) {
        this.maxProbability = maxProbability;
        this.minProbability = minProbability;
        this.defaultProbability = defaultProbability;
    }

    public void increase(Joint joint) {
        Integer probability = this.probabilityCache.get(joint);
        if (probability == null) {
            probability = this.defaultProbability;
        }
        if ((probability = Integer.valueOf(probability * probability)) > this.maxProbability) {
            probability = this.maxProbability;
        }
        this.probabilityCache.put(joint, probability);
    }

    public void decrease(Joint joint) {
        Integer probability = this.probabilityCache.get(joint);
        if (probability == null) {
            probability = this.defaultProbability;
        }
        if ((probability = Integer.valueOf((int)Math.sqrt(probability.intValue()))) < this.minProbability) {
            probability = this.minProbability;
        }
        this.probabilityCache.put(joint, probability);
    }

    public int getProbability(Joint joint) {
        Integer integer = this.probabilityCache.get(joint);
        if (integer == null) {
            integer = this.defaultProbability;
        }
        return integer;
    }

    public void resetMaxProbability(int maxProbability) {
        this.maxProbability = maxProbability;
    }
}

