/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.security;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.domain.AppToken;
import org.joyqueue.exception.JoyQueueCode;
import org.joyqueue.exception.JoyQueueException;
import org.joyqueue.response.BooleanResponse;
import org.joyqueue.security.Authentication;
import org.joyqueue.security.PasswordEncoder;
import org.joyqueue.security.UserDetails;
import org.joyqueue.toolkit.time.SystemClock;

public class AppTokenAuthentication
implements Authentication,
BrokerContextAware {
    public static final String DEFAULT_ADMIN_USER = "joyqueue";
    private String admin = "joyqueue";
    private ClusterManager clusterManager;

    public AppTokenAuthentication() {
    }

    public AppTokenAuthentication(ClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public AppTokenAuthentication(ClusterManager clusterManager, String admin) {
        this(clusterManager);
        this.admin = admin;
    }

    public UserDetails getUser(String user) throws JoyQueueException {
        return null;
    }

    public PasswordEncoder getPasswordEncode() {
        return null;
    }

    public BooleanResponse auth(String userName, String password) {
        AppToken appToken = this.clusterManager.getAppToken(userName, password);
        if (null == appToken) {
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.CN_AUTHENTICATION_ERROR);
        }
        long now = SystemClock.now();
        if (now < appToken.getEffectiveTime().getTime() || now > appToken.getExpirationTime().getTime()) {
            return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.CN_AUTHENTICATION_ERROR);
        }
        return BooleanResponse.success();
    }

    public BooleanResponse auth(String userName, String password, boolean checkAdmin) {
        BooleanResponse response = this.auth(userName, password);
        if (response.isSuccess() && (!checkAdmin || this.isAdmin(userName))) {
            return response;
        }
        return BooleanResponse.failed((JoyQueueCode)JoyQueueCode.CN_AUTHENTICATION_ERROR);
    }

    public boolean isAdmin(String userName) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return false;
        }
        return userName.equals(this.admin);
    }

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        this.clusterManager = brokerContext.getClusterManager();
        Preconditions.checkArgument((this.clusterManager != null ? 1 : 0) != 0, (Object)"cluster manager can not be null");
        String adminUser = this.clusterManager.getConfig().getAdminUser();
        if (StringUtils.isNotBlank((CharSequence)adminUser)) {
            this.admin = adminUser;
        }
    }
}

