/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.store;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.jd.laf.extension.Extension;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.Plugins;
import org.joyqueue.broker.election.DefaultElectionNode;
import org.joyqueue.broker.election.ElectionEvent;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.election.LeaderElection;
import org.joyqueue.domain.QosLevel;
import org.joyqueue.domain.TopicName;
import org.joyqueue.monitor.BufferPoolMonitorInfo;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.StoreManagementService;
import org.joyqueue.store.StoreNode;
import org.joyqueue.store.StoreNodes;
import org.joyqueue.store.StoreService;
import org.joyqueue.store.event.StoreEvent;
import org.joyqueue.store.event.StoreNodeChangeEvent;
import org.joyqueue.store.replication.ReplicableStore;
import org.joyqueue.store.transaction.TransactionStore;
import org.joyqueue.toolkit.concurrent.EventBus;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.lang.LifeCycle;
import org.joyqueue.toolkit.service.Service;

@Extension(order=0)
public class ClusterStoreService
extends Service
implements StoreService,
LifeCycle,
Closeable,
PropertySupplierAware,
BrokerContextAware {
    private StoreService storeService;
    private BrokerContext brokerContext;
    private ElectionService electionService;
    private EventBus eventBus = new EventBus("joyqueue-cluster-store-eventBus");

    protected StoreService loadStoreService() {
        for (StoreService storeService : Plugins.STORE.extensions()) {
            if (storeService.getClass().equals(this.getClass())) continue;
            return storeService;
        }
        return null;
    }

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
    }

    protected void validate() throws Exception {
        this.electionService = this.brokerContext.getElectionService();
        this.electionService.addListener((EventListener<ElectionEvent>)((EventListener)event -> {
            LeaderElection leaderElection = this.electionService.getLeaderElection(TopicName.parse((String)event.getTopicPartitionGroup().getTopic()), event.getTopicPartitionGroup().getPartitionGroupId());
            if (leaderElection == null) {
                return;
            }
            StoreNodes storeNodes = this.convertElectionNodes(leaderElection);
            this.eventBus.add((Object)new StoreNodeChangeEvent(event.getTopicPartitionGroup().getTopic(), event.getTopicPartitionGroup().getPartitionGroupId(), storeNodes));
        }));
    }

    protected void doStart() throws Exception {
        if (this.storeService instanceof LifeCycle) {
            ((LifeCycle)this.storeService).start();
        }
        this.eventBus.start();
    }

    protected void doStop() {
        if (this.storeService instanceof LifeCycle) {
            ((LifeCycle)this.storeService).stop();
        }
        this.eventBus.stop();
    }

    @Override
    public void close() throws IOException {
        if (this.storeService instanceof Closeable) {
            ((Closeable)this.storeService).close();
        }
    }

    public void setSupplier(PropertySupplier supplier) {
        this.storeService = this.loadStoreService();
        Preconditions.checkArgument((this.storeService != null ? 1 : 0) != 0, (Object)"storeService can not be null.");
        if (this.storeService instanceof PropertySupplierAware) {
            ((PropertySupplierAware)this.storeService).setSupplier(supplier);
        }
    }

    public StoreNodes getNodes(String topic, int partitionGroup) {
        LeaderElection leaderElection = this.electionService.getLeaderElection(TopicName.parse((String)topic), partitionGroup);
        if (leaderElection == null) {
            return null;
        }
        return this.convertElectionNodes(leaderElection);
    }

    protected StoreNodes convertElectionNodes(LeaderElection leaderElection) {
        Collection<DefaultElectionNode> electionNodes = leaderElection.getAllNodes();
        ArrayList nodes = Lists.newArrayListWithCapacity((int)electionNodes.size());
        for (DefaultElectionNode electionNode : electionNodes) {
            boolean isLeader = electionNode.getNodeId() == leaderElection.getLeaderId();
            nodes.add(new StoreNode(electionNode.getNodeId(), isLeader, isLeader));
        }
        return new StoreNodes((List)nodes);
    }

    public void addListener(EventListener<StoreEvent> listener) {
        this.eventBus.addListener(listener);
    }

    public void removeListener(EventListener<StoreEvent> listener) {
        this.eventBus.removeListener(listener);
    }

    public boolean partitionGroupExists(String topic, int partitionGroup) {
        return this.storeService.partitionGroupExists(topic, partitionGroup);
    }

    public boolean topicExists(String topic) {
        return this.storeService.topicExists(topic);
    }

    public TransactionStore getTransactionStore(String topic) {
        return this.storeService.getTransactionStore(topic);
    }

    public List<TransactionStore> getAllTransactionStores() {
        return this.storeService.getAllTransactionStores();
    }

    public void removePartitionGroup(String topic, int partitionGroup) {
        this.storeService.removePartitionGroup(topic, partitionGroup);
    }

    public void restorePartitionGroup(String topic, int partitionGroup) throws Exception {
        this.storeService.restorePartitionGroup(topic, partitionGroup);
    }

    public void createPartitionGroup(String topic, int partitionGroup, short[] partitions) throws Exception {
        this.storeService.createPartitionGroup(topic, partitionGroup, partitions);
    }

    public PartitionGroupStore getStore(String topic, int partitionGroup, QosLevel writeQosLevel) {
        return this.storeService.getStore(topic, partitionGroup, writeQosLevel);
    }

    public PartitionGroupStore getStore(String topic, int partitionGroup) {
        return this.storeService.getStore(topic, partitionGroup);
    }

    public List<PartitionGroupStore> getStore(String topic) {
        return this.storeService.getStore(topic);
    }

    public void rePartition(String topic, int partitionGroup, Short[] partitions) throws IOException {
        this.storeService.rePartition(topic, partitionGroup, partitions);
    }

    public ReplicableStore getReplicableStore(String topic, int partitionGroup) {
        return this.storeService.getReplicableStore(topic, partitionGroup);
    }

    public StoreManagementService getManageService() {
        return this.storeService.getManageService();
    }

    public BufferPoolMonitorInfo monitorInfo() {
        return this.storeService.monitorInfo();
    }
}

