/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.store;

import java.io.IOException;
import java.util.Map;
import org.joyqueue.broker.config.BrokerStoreConfig;
import org.joyqueue.broker.store.AbstractStoreCleaningStrategy;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.toolkit.config.PropertySupplier;

public class FixedSizeStoreCleaningStrategy
extends AbstractStoreCleaningStrategy {
    private long maxStorageSize;

    @Override
    public long deleteIfNeeded(PartitionGroupStore partitionGroupStore, Map<Short, Long> partitionAckMap) throws IOException {
        long currentTotalStorageSize;
        long totalDeletedSize = 0L;
        if (partitionGroupStore != null && this.maxStorageSize < (currentTotalStorageSize = partitionGroupStore.getTotalPhysicalStorageSize())) {
            long lastDeletedSize;
            long targetDeleteSize = currentTotalStorageSize - this.maxStorageSize;
            while ((lastDeletedSize = partitionGroupStore.clean(0L, partitionAckMap, this.keepUnconsumed(partitionGroupStore.getTopic()))) > 0L && (totalDeletedSize += lastDeletedSize) < targetDeleteSize) {
            }
        }
        return totalDeletedSize;
    }

    @Override
    public void setSupplier(PropertySupplier supplier) {
        super.setSupplier(supplier);
        BrokerStoreConfig brokerStoreConfig = new BrokerStoreConfig(supplier);
        this.maxStorageSize = brokerStoreConfig.getMaxStoreSize();
    }
}

