/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.store;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.joyqueue.broker.config.BrokerStoreConfig;
import org.joyqueue.broker.store.AbstractStoreCleaningStrategy;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalStorageLimitCleaningStrategy
extends AbstractStoreCleaningStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalStorageLimitCleaningStrategy.class);
    private long forceCleanWALStorageSizeThreshold;
    private long stopCleanWALStorageSizeThreshold;
    private String applicationDataPath;
    private File applicationDataDirectory;
    private long totalStorageSize;
    private Map<String, Boolean> partitionGroupForcibleCleanWal = new HashMap<String, Boolean>();
    private StorageState storageState = StorageState.SAFETY;

    @Override
    public long deleteIfNeeded(PartitionGroupStore partitionGroupStore, Map<Short, Long> partitionAckMap) throws IOException {
        if (partitionGroupStore == null) {
            return -1L;
        }
        long now = SystemClock.now();
        long used = 0L;
        long maxStoreTime = this.storeLogMaxTime(partitionGroupStore.getTopic());
        boolean keepUnconsumed = this.keepUnconsumed(partitionGroupStore.getTopic());
        if (LOG.isDebugEnabled()) {
            LOG.info("topic {},Dynamic max store time {} ms,keep unconsumed {}", new Object[]{partitionGroupStore.getTopic(), maxStoreTime, keepUnconsumed});
        }
        long cleanWALBeforeTime = now - maxStoreTime;
        long totalDeletedSize = 0L;
        long deletedSize = 0L;
        do {
            deletedSize = partitionGroupStore.clean(cleanWALBeforeTime, partitionAckMap, keepUnconsumed);
            totalDeletedSize += deletedSize;
        } while (deletedSize > 0L);
        String partitionGroupKey = String.format("%s:%d", partitionGroupStore.getTopic(), partitionGroupStore.getPartitionGroup());
        Boolean force = this.partitionGroupForcibleCleanWal.get(partitionGroupKey);
        if (force == null) {
            this.partitionGroupForcibleCleanWal.put(partitionGroupKey, true);
            force = false;
        }
        if (force.booleanValue() && this.storageState == StorageState.CLEANING) {
            used = this.usedStorageSize();
            if (used > this.stopCleanWALStorageSizeThreshold) {
                totalDeletedSize += partitionGroupStore.clean(-1L, partitionAckMap, keepUnconsumed);
            } else {
                this.storageState = StorageState.SAFETY;
                this.partitionGroupForcibleCleanWal.clear();
                LOG.info("current storage state:{},force clean storage threshold {} byte,used storage {} byte", new Object[]{this.storageState, this.forceCleanWALStorageSizeThreshold, used});
            }
        } else if (force.booleanValue() && StorageState.SAFETY == this.storageState && (used = this.usedStorageSize()) >= this.forceCleanWALStorageSizeThreshold) {
            this.storageState = StorageState.CLEANING;
            LOG.info("current storage state:{},force clean storage threshold {} byte,used storage {} byte", new Object[]{this.storageState, this.forceCleanWALStorageSizeThreshold, used});
        }
        return totalDeletedSize;
    }

    public StorageState state() {
        return this.storageState;
    }

    @Override
    public void setSupplier(PropertySupplier supplier) {
        super.setSupplier(supplier);
        BrokerStoreConfig brokerStoreConfig = new BrokerStoreConfig(supplier);
        int forceCleanWALFractionThreshold = brokerStoreConfig.getStoreDiskUsageMax();
        int cleanWALUsageSafeThreshold = brokerStoreConfig.getStoreDiskUsageSafe();
        this.applicationDataPath = brokerStoreConfig.getApplicationDataPath();
        this.applicationDataDirectory = new File(this.applicationDataPath);
        this.totalStorageSize = this.totalStorageSize();
        this.forceCleanWALStorageSizeThreshold = this.totalStorageSize * (long)forceCleanWALFractionThreshold / 100L;
        this.stopCleanWALStorageSizeThreshold = this.totalStorageSize * (long)cleanWALUsageSafeThreshold / 100L;
    }

    public long usedStorageSize() {
        long usableStorageSize = 0L;
        if (this.applicationDataDirectory.exists()) {
            usableStorageSize = this.applicationDataDirectory.getUsableSpace();
        }
        return this.totalStorageSize - usableStorageSize;
    }

    public long totalStorageSize() {
        if (this.applicationDataDirectory.exists()) {
            return this.applicationDataDirectory.getTotalSpace();
        }
        return -1L;
    }

    public static enum StorageState {
        SAFETY,
        CLEANING;

    }
}

