/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.store;

import java.io.IOException;
import java.util.Map;
import org.joyqueue.broker.store.AbstractStoreCleaningStrategy;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.time.SystemClock;

public class IntervalTimeStoreCleaningStrategy
extends AbstractStoreCleaningStrategy {
    @Override
    public long deleteIfNeeded(PartitionGroupStore partitionGroupStore, Map<Short, Long> partitionAckMap) throws IOException {
        long currentTimestamp = SystemClock.now();
        long targetDeleteTimeline = currentTimestamp - this.storeLogMaxTime(partitionGroupStore.getTopic());
        long totalDeletedSize = 0L;
        long deletedSize = 0L;
        if (partitionGroupStore != null) {
            do {
                deletedSize = partitionGroupStore.clean(targetDeleteTimeline, partitionAckMap, this.keepUnconsumed(partitionGroupStore.getTopic()));
                totalDeletedSize += deletedSize;
            } while (deletedSize > 0L);
        }
        return totalDeletedSize;
    }

    @Override
    public void setSupplier(PropertySupplier supplier) {
        super.setSupplier(supplier);
    }
}

