/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.store;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.jd.laf.extension.ExtensionManager;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.config.BrokerStoreConfig;
import org.joyqueue.broker.consumer.position.PositionManager;
import org.joyqueue.broker.store.StoreCleaningStrategy;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.time.SystemClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreCleanManager
extends Service {
    private static final Logger LOG = LoggerFactory.getLogger(StoreCleanManager.class);
    private static final int SCHEDULE_EXECUTOR_THREADS = 16;
    private PropertySupplier propertySupplier;
    private BrokerStoreConfig brokerStoreConfig;
    private StoreService storeService;
    private ClusterManager clusterManager;
    private PositionManager positionManager;
    private Map<String, StoreCleaningStrategy> cleaningStrategyMap;
    private final ScheduledExecutorService scheduledExecutorService;
    private ScheduledFuture cleanFuture;

    public StoreCleanManager(PropertySupplier propertySupplier, StoreService storeService, ClusterManager clusterManager, PositionManager positionManager) {
        this.propertySupplier = propertySupplier;
        this.brokerStoreConfig = new BrokerStoreConfig(propertySupplier);
        this.storeService = storeService;
        this.clusterManager = clusterManager;
        this.positionManager = positionManager;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(16, (ThreadFactory)new NamedThreadFactory("StoreCleaning-Scheduled-Executor"));
    }

    protected void validate() throws Exception {
        super.validate();
        Preconditions.checkArgument((this.propertySupplier != null ? 1 : 0) != 0, (Object)"property supplier can not be null");
        Preconditions.checkArgument((this.storeService != null ? 1 : 0) != 0, (Object)"store service can not be null");
        Preconditions.checkArgument((this.positionManager != null ? 1 : 0) != 0, (Object)"position manager can not be null");
        List<StoreCleaningStrategy> storeCleaningStrategies = this.initStoreCleaningStrategyList();
        Preconditions.checkArgument((storeCleaningStrategies.size() != 0 ? 1 : 0) != 0, (Object)"load cleaning strategy list can not be null");
        this.cleaningStrategyMap = new HashMap<String, StoreCleaningStrategy>(storeCleaningStrategies.size());
        for (StoreCleaningStrategy cleaningStrategy : storeCleaningStrategies) {
            cleaningStrategy.setSupplier(this.propertySupplier);
            this.cleaningStrategyMap.put(cleaningStrategy.getClass().getSimpleName(), cleaningStrategy);
        }
    }

    private List<StoreCleaningStrategy> initStoreCleaningStrategyList() {
        return Lists.newArrayList((Iterable)ExtensionManager.getOrLoadExtensions(StoreCleaningStrategy.class));
    }

    public void start() throws Exception {
        super.start();
        this.cleanFuture = this.scheduledExecutorService.scheduleWithFixedDelay(this::clean, ThreadLocalRandom.current().nextLong(this.brokerStoreConfig.getStoreCleanScheduleBegin(), this.brokerStoreConfig.getStoreCleanScheduleEnd()), ThreadLocalRandom.current().nextLong(this.brokerStoreConfig.getStoreCleanScheduleBegin(), this.brokerStoreConfig.getStoreCleanScheduleEnd()), TimeUnit.MILLISECONDS);
    }

    public void stop() {
        super.stop();
        try {
            long stopTimeout = 5000L;
            if (this.cleanFuture != null) {
                long t0 = SystemClock.now();
                while (!this.cleanFuture.isDone()) {
                    if (SystemClock.now() - t0 > stopTimeout) {
                        throw new TimeoutException("Wait for async store clean job timeout!");
                    }
                    this.cleanFuture.cancel(true);
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        LOG.warn("Exception: ", (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable t) {
            LOG.error(t.getMessage(), t);
        }
    }

    private void clean() {
        long roundDeleteStoreSize;
        if (LOG.isDebugEnabled()) {
            LOG.info("Start scheduled StoreCleaningStrategy task use class: <{}>!!!", (Object)this.brokerStoreConfig.getCleanStrategyClass());
        }
        long roundTotalDeleteStoreSize = 0L;
        long startMs = SystemClock.now();
        do {
            roundDeleteStoreSize = 0L;
            List<TopicConfig> topicConfigs = this.clusterManager.getTopics();
            if (topicConfigs != null && topicConfigs.size() > 0) {
                for (TopicConfig topicConfig : topicConfigs) {
                    List<PartitionGroup> partitionGroups = this.clusterManager.getTopicPartitionGroups(topicConfig.getName());
                    if (!CollectionUtils.isNotEmpty(partitionGroups)) continue;
                    for (PartitionGroup partitionGroup : partitionGroups) {
                        try {
                            Set partitions = partitionGroup.getPartitions();
                            if (!CollectionUtils.isNotEmpty((Collection)partitions)) continue;
                            List<String> appList = this.clusterManager.getAppByTopic(topicConfig.getName());
                            HashMap<Short, Long> partitionAckMap = new HashMap<Short, Long>(partitions.size());
                            for (Short partition : partitions) {
                                long minAckIndex = Long.MAX_VALUE;
                                if (CollectionUtils.isNotEmpty(appList)) {
                                    for (String app : appList) {
                                        minAckIndex = Math.min(minAckIndex, this.positionManager.getLastMsgAckIndex(topicConfig.getName(), app, partition));
                                    }
                                }
                                partitionAckMap.put(partition, minAckIndex);
                            }
                            StoreCleaningStrategy cleaningStrategy = this.cleaningStrategyMap.get(this.brokerStoreConfig.getCleanStrategyClass());
                            if (cleaningStrategy == null) continue;
                            if (LOG.isDebugEnabled()) {
                                LOG.info("Begin store clean topic: <{}>, partition group: <{}>, partition ack map: <{}>", new Object[]{topicConfig.getName().getFullName(), partitionGroup.getGroup(), partitionAckMap});
                            }
                            roundDeleteStoreSize = cleaningStrategy.deleteIfNeeded(this.storeService.getStore(topicConfig.getName().getFullName(), partitionGroup.getGroup()), partitionAckMap);
                        }
                        catch (Throwable t) {
                            LOG.error("Error to clean store for topic <{}>, partition group <{}>, exception: {}", new Object[]{topicConfig, partitionGroup.getGroup(), t});
                        }
                    }
                }
            }
            roundTotalDeleteStoreSize += roundDeleteStoreSize;
        } while (roundDeleteStoreSize > 0L);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Round total clean storage size {},elapsed time {}ms", (Object)roundTotalDeleteStoreSize, (Object)(SystemClock.now() - startMs));
        }
    }
}

