/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.store;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Shorts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.collections.CollectionUtils;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.cluster.event.CompensateEvent;
import org.joyqueue.broker.config.BrokerStoreConfig;
import org.joyqueue.broker.election.DefaultElectionNode;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.election.LeaderElection;
import org.joyqueue.domain.Broker;
import org.joyqueue.domain.PartitionGroup;
import org.joyqueue.domain.Replica;
import org.joyqueue.domain.TopicConfig;
import org.joyqueue.domain.TopicName;
import org.joyqueue.event.MetaEvent;
import org.joyqueue.nsr.NameService;
import org.joyqueue.nsr.event.AddPartitionGroupEvent;
import org.joyqueue.nsr.event.AddTopicEvent;
import org.joyqueue.nsr.event.LeaderChangeEvent;
import org.joyqueue.nsr.event.RemovePartitionGroupEvent;
import org.joyqueue.nsr.event.RemoveTopicEvent;
import org.joyqueue.nsr.event.UpdatePartitionGroupEvent;
import org.joyqueue.store.PartitionGroupStore;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.concurrent.EventListener;
import org.joyqueue.toolkit.concurrent.NamedThreadFactory;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreInitializer
extends Service
implements EventListener<MetaEvent> {
    protected static final Logger logger = LoggerFactory.getLogger(StoreInitializer.class);
    private BrokerStoreConfig config;
    private NameService nameService;
    private ClusterManager clusterManager;
    private StoreService storeService;
    private ElectionService electionService;

    public StoreInitializer(BrokerStoreConfig config, NameService nameService, ClusterManager clusterManager, StoreService storeService, ElectionService electionService) {
        this.config = config;
        this.nameService = nameService;
        this.clusterManager = clusterManager;
        this.storeService = storeService;
        this.electionService = electionService;
    }

    protected void doStart() throws Exception {
        this.restore();
        this.clusterManager.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restore() throws Exception {
        Broker broker = this.clusterManager.getBroker();
        List replicas = this.nameService.getReplicaByBroker(broker.getId());
        if (CollectionUtils.isEmpty((Collection)replicas)) {
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(32, (ThreadFactory)new NamedThreadFactory("Store-recover-threads"));
        try {
            CompletableFuture.allOf((CompletableFuture[])replicas.stream().map(replica -> CompletableFuture.runAsync(() -> {
                try {
                    PartitionGroup group = this.clusterManager.getPartitionGroupByGroup(replica.getTopic(), replica.getGroup());
                    if (group == null) {
                        logger.warn("group is null topic {},replica {}", (Object)replica.getTopic(), (Object)replica.getGroup());
                        throw new RuntimeException(String.format("group is null topic %s,replica %s", replica.getTopic(), replica.getGroup()));
                    }
                    if (!group.getReplicas().contains(broker.getId())) {
                        return;
                    }
                    this.doRestore(group, (Replica)replica, broker);
                }
                catch (Exception e) {
                    throw new CompletionException(e);
                }
            }, executor)).toArray(CompletableFuture[]::new)).get();
        }
        finally {
            executor.shutdown();
        }
    }

    protected void doRestore(PartitionGroup group, Replica replica, Broker broker) throws Exception {
        if (this.config.getForceRestore()) {
            logger.info("force restore topic {}, group.no {} group {}", new Object[]{replica.getTopic().getFullName(), replica.getGroup(), group});
            if (this.storeService.partitionGroupExists(group.getTopic().getFullName(), group.getGroup())) {
                this.storeService.restorePartitionGroup(group.getTopic().getFullName(), group.getGroup());
            } else {
                logger.warn("create partitionGroup store, topic {},group.no {} group {}", new Object[]{replica.getTopic().getFullName(), replica.getGroup(), group});
                this.storeService.createPartitionGroup(replica.getTopic().getFullName(), group.getGroup(), Shorts.toArray((Collection)group.getPartitions()));
            }
        } else {
            logger.info("restore topic {}, group.no {} group {}", new Object[]{replica.getTopic().getFullName(), replica.getGroup(), group});
            this.storeService.restorePartitionGroup(group.getTopic().getFullName(), group.getGroup());
        }
    }

    public void onEvent(MetaEvent event) {
        try {
            switch (event.getEventType()) {
                case ADD_TOPIC: {
                    AddTopicEvent addTopicEvent = (AddTopicEvent)event;
                    for (PartitionGroup partitionGroup : addTopicEvent.getPartitionGroups()) {
                        this.onAddPartitionGroup(addTopicEvent.getTopic().getName(), partitionGroup);
                    }
                    break;
                }
                case REMOVE_TOPIC: {
                    RemoveTopicEvent removeTopicEvent = (RemoveTopicEvent)event;
                    for (PartitionGroup partitionGroup : removeTopicEvent.getPartitionGroups()) {
                        this.onRemovePartitionGroup(removeTopicEvent.getTopic().getName(), partitionGroup);
                    }
                    break;
                }
                case ADD_PARTITION_GROUP: {
                    AddPartitionGroupEvent addPartitionGroupEvent = (AddPartitionGroupEvent)event;
                    this.onAddPartitionGroup(addPartitionGroupEvent.getTopic(), addPartitionGroupEvent.getPartitionGroup());
                    break;
                }
                case UPDATE_PARTITION_GROUP: {
                    UpdatePartitionGroupEvent updatePartitionGroupEvent = (UpdatePartitionGroupEvent)event;
                    this.onUpdatePartitionGroup(updatePartitionGroupEvent.getTopic(), updatePartitionGroupEvent.getOldPartitionGroup(), updatePartitionGroupEvent.getNewPartitionGroup());
                    break;
                }
                case REMOVE_PARTITION_GROUP: {
                    RemovePartitionGroupEvent removePartitionGroupEvent = (RemovePartitionGroupEvent)event;
                    this.onRemovePartitionGroup(removePartitionGroupEvent.getTopic(), removePartitionGroupEvent.getPartitionGroup());
                    break;
                }
                case LEADER_CHANGE: {
                    LeaderChangeEvent leaderChangeEvent = (LeaderChangeEvent)event;
                    this.onLeaderChange(leaderChangeEvent.getTopic(), leaderChangeEvent.getOldPartitionGroup(), leaderChangeEvent.getNewPartitionGroup());
                    break;
                }
                case COMPENSATE: {
                    CompensateEvent compensateEvent = (CompensateEvent)event;
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error("onEvent exception, event: {}", (Object)event, (Object)e);
            throw new RuntimeException(e);
        }
    }

    protected void onCompensate(Map<TopicName, TopicConfig> topics) {
        for (Map.Entry<TopicName, TopicConfig> topicEntry : topics.entrySet()) {
            TopicConfig topicConfig = topicEntry.getValue();
            for (Map.Entry groupEntry : topicConfig.getPartitionGroups().entrySet()) {
                PartitionGroup partitionGroup = (PartitionGroup)groupEntry.getValue();
                PartitionGroupStore store = this.storeService.getStore(topicConfig.getName().getFullName(), partitionGroup.getGroup());
                LeaderElection leaderElection = this.electionService.getLeaderElection(topicConfig.getName(), partitionGroup.getGroup());
                try {
                    if (store == null) {
                        logger.info("store create partitionGroup, topic: {}, group: {}", (Object)topicConfig.getName(), (Object)partitionGroup.getGroup());
                        this.storeService.createPartitionGroup(topicConfig.getName().getFullName(), partitionGroup.getGroup(), Shorts.toArray((Collection)partitionGroup.getPartitions()));
                    } else if (!Arrays.equals((Object[])store.listPartitions(), (Object[])partitionGroup.getPartitions().toArray(new Short[0]))) {
                        logger.info("store partition, topic: {}, group: {}, partition {} -> {}", new Object[]{topicConfig.getName(), partitionGroup.getGroup(), Arrays.toString((Object[])store.listPartitions()), partitionGroup.getPartitions()});
                        this.storeService.rePartition(topicConfig.getName().getFullName(), partitionGroup.getGroup(), partitionGroup.getPartitions().toArray(new Short[0]));
                    }
                    if (leaderElection == null) {
                        Iterator<Broker> brokers = Lists.newLinkedList();
                        for (Integer replica : partitionGroup.getReplicas()) {
                            brokers.add(this.nameService.getBroker(replica.intValue()));
                        }
                        logger.info("store create partitionGroup, topic: {}, group: {}", (Object)topicConfig.getName(), (Object)partitionGroup.getGroup());
                        this.electionService.onPartitionGroupCreate(partitionGroup.getElectType(), topicConfig.getName(), partitionGroup.getGroup(), (List<Broker>)((Object)brokers), partitionGroup.getLearners(), this.clusterManager.getBrokerId(), partitionGroup.getLeader());
                        continue;
                    }
                    for (DefaultElectionNode electionNode : leaderElection.getAllNodes()) {
                        if (partitionGroup.getReplicas().contains(electionNode.getNodeId())) continue;
                        logger.info("election remove node, topic: {}, group: {}, replica: {}", new Object[]{topicConfig.getName(), partitionGroup.getGroup(), electionNode.getNodeId()});
                        this.electionService.onNodeRemove(topicConfig.getName(), partitionGroup.getGroup(), electionNode.getNodeId(), this.clusterManager.getBrokerId());
                        this.storeService.rePartition(topicConfig.getName().getFullName(), partitionGroup.getGroup(), partitionGroup.getPartitions().toArray(new Short[0]));
                    }
                    for (Integer replica : partitionGroup.getReplicas()) {
                        boolean isExist = false;
                        for (DefaultElectionNode electionNode : leaderElection.getAllNodes()) {
                            if (electionNode.getNodeId() != replica.intValue()) continue;
                            isExist = true;
                            break;
                        }
                        if (isExist) continue;
                        LinkedList brokers = Lists.newLinkedList();
                        for (Integer partitionGroupReplica : partitionGroup.getReplicas()) {
                            brokers.add(this.nameService.getBroker(partitionGroupReplica.intValue()));
                        }
                        logger.info("election add node, topic: {}, group: {}, replica: {}", new Object[]{topicConfig.getName(), partitionGroup.getGroup(), replica});
                        this.electionService.onNodeAdd(topicConfig.getName(), partitionGroup.getGroup(), partitionGroup.getElectType(), brokers, partitionGroup.getLearners(), this.nameService.getBroker(replica.intValue()), this.clusterManager.getBrokerId(), partitionGroup.getLeader());
                        this.storeService.rePartition(topicConfig.getName().getFullName(), partitionGroup.getGroup(), partitionGroup.getPartitions().toArray(new Short[0]));
                    }
                }
                catch (Exception e) {
                    logger.error("compensate exception, topic: {}, group: {}", new Object[]{topicConfig.getName(), partitionGroup.getGroup(), e});
                }
            }
        }
        List<LeaderElection> leaderElections = this.electionService.getLeaderElections();
        for (LeaderElection leaderElection : leaderElections) {
            TopicName topic = TopicName.parse((String)leaderElection.getTopicPartitionGroup().getTopic());
            int group = leaderElection.getTopicPartitionGroup().getPartitionGroupId();
            if (topics.containsKey(topic)) continue;
            try {
                logger.info("election remove partitionGroup, topic: {}, group: {}", (Object)topic, (Object)group);
                this.storeService.removePartitionGroup(topic.getFullName(), group);
                this.electionService.onPartitionGroupRemove(topic, group);
            }
            catch (Exception e) {
                logger.error("compensate exception, topic: {}, group: {}", new Object[]{topic, group, e});
            }
        }
    }

    protected void onAddPartitionGroup(TopicName topicName, PartitionGroup partitionGroup) throws Exception {
        logger.info("onAddPartitionGroup, topic: {}, partitionGroup: {}", (Object)topicName, (Object)partitionGroup);
        Set replicas = partitionGroup.getReplicas();
        ArrayList<Broker> brokers = new ArrayList<Broker>(replicas.size());
        replicas.forEach(brokerId -> brokers.add(this.clusterManager.getBrokerById((Integer)brokerId)));
        this.storeService.createPartitionGroup(topicName.getFullName(), partitionGroup.getGroup(), Shorts.toArray((Collection)partitionGroup.getPartitions()));
        this.electionService.onPartitionGroupCreate(partitionGroup.getElectType(), partitionGroup.getTopic(), partitionGroup.getGroup(), brokers, partitionGroup.getLearners(), this.clusterManager.getBrokerId(), partitionGroup.getLeader());
    }

    protected void onUpdatePartitionGroup(TopicName topicName, PartitionGroup oldPartitionGroup, PartitionGroup newPartitionGroup) throws Exception {
        logger.info("onUpdatePartitionGroup, topic: {}, oldPartitionGroup: {}, newPartition: {}", new Object[]{topicName, oldPartitionGroup, newPartitionGroup});
        int currentBrokerId = this.clusterManager.getBrokerId();
        HashSet newReplicas = Sets.newHashSet((Iterable)newPartitionGroup.getReplicas());
        HashSet oldReplicas = Sets.newHashSet((Iterable)oldPartitionGroup.getReplicas());
        newReplicas.removeAll(oldReplicas);
        oldReplicas.removeAll(newReplicas);
        LinkedList brokers = Lists.newLinkedList();
        for (Integer newReplica : newPartitionGroup.getReplicas()) {
            brokers.add(this.nameService.getBroker(newReplica.intValue()));
        }
        for (Integer newReplica : newPartitionGroup.getReplicas()) {
            if (oldPartitionGroup.getReplicas().contains(newReplica)) continue;
            if (newReplica.equals(currentBrokerId)) {
                logger.info("topic[{}] add partitionGroup[{}]", (Object)topicName, (Object)newPartitionGroup.getGroup());
                this.storeService.createPartitionGroup(topicName.getFullName(), newPartitionGroup.getGroup(), Shorts.toArray((Collection)newPartitionGroup.getPartitions()));
                this.electionService.onPartitionGroupCreate(newPartitionGroup.getElectType(), topicName, newPartitionGroup.getGroup(), brokers, newPartitionGroup.getLearners(), this.clusterManager.getBrokerId(), newPartitionGroup.getLeader());
                continue;
            }
            logger.info("topic[{}] update partitionGroup[{}] add node[{}] ", new Object[]{topicName, newPartitionGroup.getGroup(), newReplica});
            this.electionService.onNodeAdd(topicName, newPartitionGroup.getGroup(), newPartitionGroup.getElectType(), brokers, newPartitionGroup.getLearners(), this.nameService.getBroker(newReplica.intValue()), currentBrokerId, newPartitionGroup.getLeader());
            this.storeService.rePartition(topicName.getFullName(), newPartitionGroup.getGroup(), newPartitionGroup.getPartitions().toArray(new Short[newPartitionGroup.getPartitions().size()]));
        }
        if (oldPartitionGroup.getPartitions().size() != newPartitionGroup.getPartitions().size()) {
            this.storeService.rePartition(topicName.getFullName(), newPartitionGroup.getGroup(), newPartitionGroup.getPartitions().toArray(new Short[newPartitionGroup.getPartitions().size()]));
        }
        for (Integer oldReplica : oldPartitionGroup.getReplicas()) {
            if (newPartitionGroup.getReplicas().contains(oldReplica)) continue;
            if (oldReplica.equals(currentBrokerId)) {
                logger.info("topic[{}] add partitionGroup[{}]", (Object)topicName, (Object)newPartitionGroup.getGroup());
                this.storeService.removePartitionGroup(topicName.getFullName(), newPartitionGroup.getGroup());
                this.electionService.onPartitionGroupRemove(topicName, newPartitionGroup.getGroup());
                continue;
            }
            logger.info("topic[{}] update partitionGroup[{}] add node[{}] ", new Object[]{topicName, newPartitionGroup.getGroup(), oldReplica});
            this.electionService.onNodeRemove(topicName, newPartitionGroup.getGroup(), oldReplica, currentBrokerId);
            this.storeService.rePartition(topicName.getFullName(), newPartitionGroup.getGroup(), newPartitionGroup.getPartitions().toArray(new Short[newPartitionGroup.getPartitions().size()]));
        }
    }

    protected void onRemovePartitionGroup(TopicName topicName, PartitionGroup partitionGroup) throws Exception {
        logger.info("onRemovePartitionGroup, topic: {}, partitionGroup: {}", (Object)topicName, (Object)partitionGroup);
        this.storeService.removePartitionGroup(topicName.getFullName(), partitionGroup.getGroup());
        this.electionService.onPartitionGroupRemove(topicName, partitionGroup.getGroup());
    }

    protected void onLeaderChange(TopicName topicName, PartitionGroup oldPartitionGroup, PartitionGroup newPartitionGroup) throws Exception {
        logger.info("onLeaderChange, topic: {}, partitionGroup: {}", (Object)topicName, (Object)newPartitionGroup);
        this.electionService.onLeaderChange(topicName, newPartitionGroup.getGroup(), newPartitionGroup.getLeader());
    }
}

