/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.broker.store;

import com.google.common.base.Preconditions;
import org.joyqueue.broker.BrokerContext;
import org.joyqueue.broker.BrokerContextAware;
import org.joyqueue.broker.cluster.ClusterManager;
import org.joyqueue.broker.config.BrokerStoreConfig;
import org.joyqueue.broker.election.ElectionService;
import org.joyqueue.broker.store.StoreCleanManager;
import org.joyqueue.nsr.NameService;
import org.joyqueue.store.StoreService;
import org.joyqueue.toolkit.config.PropertySupplier;
import org.joyqueue.toolkit.config.PropertySupplierAware;
import org.joyqueue.toolkit.service.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreManager
extends Service
implements BrokerContextAware,
PropertySupplierAware {
    private static final Logger logger = LoggerFactory.getLogger(StoreManager.class);
    private BrokerContext brokerContext;
    private PropertySupplier propertySupplier;
    private NameService nameService;
    private ClusterManager clusterManager;
    private StoreService storeService;
    private StoreCleanManager storeCleanManager;
    private ElectionService electionService;
    private BrokerStoreConfig config;

    public StoreManager(StoreService storeService, NameService nameService, ClusterManager clusterManager, ElectionService electionService) {
        this.storeService = storeService;
        this.nameService = nameService;
        this.clusterManager = clusterManager;
        this.electionService = electionService;
    }

    protected void validate() throws Exception {
        super.validate();
        Preconditions.checkArgument((this.brokerContext != null ? 1 : 0) != 0, (Object)"broker context can not be null");
        this.config = new BrokerStoreConfig(this.brokerContext.getPropertySupplier());
        this.storeCleanManager = new StoreCleanManager(this.propertySupplier, this.storeService, this.clusterManager, this.brokerContext.getPositionManager());
    }

    public void doStop() {
        this.storeCleanManager.stop();
    }

    public void doStart() throws Exception {
        this.storeCleanManager.start();
    }

    public NameService getNameService() {
        return this.nameService;
    }

    public void setNameService(NameService nameService) {
        this.nameService = nameService;
    }

    public StoreService getStoreService() {
        return this.storeService;
    }

    public void setStoreService(StoreService storeService) {
        this.storeService = storeService;
    }

    @Override
    public void setBrokerContext(BrokerContext brokerContext) {
        this.brokerContext = brokerContext;
    }

    public void setSupplier(PropertySupplier supplier) {
        this.propertySupplier = supplier;
    }
}

