/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.config;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Context
implements Serializable,
Cloneable {
    protected ConcurrentHashMap<String, Object> parameters = new ConcurrentHashMap();

    public Context() {
    }

    public Context(Map<String, Object> parameters) {
        if (parameters != null) {
            this.parameters.putAll(parameters);
        }
    }

    public <T> T getObject(String name, Class<T> clazz) {
        return (T)this.parameters.get(name);
    }

    public Object getObject(String name) {
        return this.parameters.get(name);
    }

    public String getString(String name, String defaultValue) {
        Object result = this.parameters.get(name);
        if (result == null) {
            return defaultValue;
        }
        String value = result.toString();
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    public Byte getByte(String name, Byte defaultValue) {
        Object result = this.parameters.get(name);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).byteValue();
        }
        String text = result.toString();
        if (text == null || text.isEmpty()) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(text);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Short getShort(String name, Short defaultValue) {
        Object result = this.parameters.get(name);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).shortValue();
        }
        String text = result.toString();
        if (text == null || text.isEmpty()) {
            return defaultValue;
        }
        try {
            return Short.parseShort(text);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Integer getInteger(String name, Integer defaultValue) {
        Object result = this.parameters.get(name);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).intValue();
        }
        String text = result.toString();
        if (text == null || text.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Long getLong(String name, Long defaultValue) {
        Object result = this.parameters.get(name);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).longValue();
        }
        String text = result.toString();
        if (text == null || text.isEmpty()) {
            return defaultValue;
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Float getFloat(String name, Float defaultValue) {
        Object result = this.parameters.get(name);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return Float.valueOf(((Number)result).floatValue());
        }
        String text = result.toString();
        if (text == null || text.isEmpty()) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(text));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Double getDouble(String name, Double defaultValue) {
        Object result = this.parameters.get(name);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        String text = result.toString();
        if (text == null || text.isEmpty()) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(text);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Boolean getBoolean(String name, Boolean defaultValue) {
        Object result = this.parameters.get(name);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return ((Number)result).longValue() != 0L;
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        String value = result.toString();
        if ("true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value)) {
            return false;
        }
        try {
            return Long.parseLong(value) != 0L;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Date getDate(String key, Date defaultValue) {
        Object result = this.parameters.get(key);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return new Date(((Number)result).longValue());
        }
        if (result instanceof Date) {
            return (Date)result;
        }
        String value = result.toString();
        try {
            return new Date(Long.parseLong(value));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Date getDate(String key, SimpleDateFormat format, Date defaultValue) {
        Object result = this.parameters.get(key);
        if (result == null) {
            return defaultValue;
        }
        if (result instanceof Number) {
            return new Date(((Number)result).longValue());
        }
        if (result instanceof Date) {
            return (Date)result;
        }
        if (format == null) {
            return defaultValue;
        }
        String value = result.toString();
        try {
            return format.parse(value);
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    public Byte getPositive(String name, Byte defaultValue) {
        if (defaultValue != null && defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        Byte result = this.getByte(name, defaultValue);
        return result != null && result <= 0 ? defaultValue : result;
    }

    public Short getPositive(String name, Short defaultValue) {
        if (defaultValue != null && defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        Short result = this.getShort(name, defaultValue);
        return result != null && result <= 0 ? defaultValue : result;
    }

    public Integer getPositive(String name, Integer defaultValue) {
        if (defaultValue != null && defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        Integer result = this.getInteger(name, defaultValue);
        return result != null && result <= 0 ? defaultValue : result;
    }

    public Long getPositive(String name, Long defaultValue) {
        if (defaultValue != null && defaultValue <= 0L) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        Long result = this.getLong(name, defaultValue);
        return result != null && result <= 0L ? defaultValue : result;
    }

    public Short getNatural(String name, Short defaultValue) {
        if (defaultValue != null && defaultValue < 0) {
            throw new IllegalArgumentException("defaultValue < 0");
        }
        Short result = this.getShort(name, defaultValue);
        return result != null && result < 0 ? defaultValue : result;
    }

    public Byte getNatural(String name, Byte defaultValue) {
        if (defaultValue != null && defaultValue < 0) {
            throw new IllegalArgumentException("defaultValue < 0");
        }
        Byte result = this.getByte(name, defaultValue);
        return result != null && result < 0 ? defaultValue : result;
    }

    public Integer getNatural(String name, Integer defaultValue) {
        if (defaultValue != null && defaultValue < 0) {
            throw new IllegalArgumentException("defaultValue < 0");
        }
        Integer result = this.getInteger(name, defaultValue);
        return result != null && result < 0 ? defaultValue : result;
    }

    public Long getNatural(String name, Long defaultValue) {
        if (defaultValue != null && defaultValue < 0L) {
            throw new IllegalArgumentException("defaultValue < 0");
        }
        Long result = this.getLong(name, defaultValue);
        return result != null && result < 0L ? defaultValue : result;
    }

    public Object put(String key, Object value) {
        return this.parameters.put(key, value);
    }

    public Object putIfAbsent(String key, Object value) {
        return this.parameters.putIfAbsent(key, value);
    }

    public void put(Map<String, ?> map) {
        if (map != null) {
            this.parameters.putAll(map);
        }
    }

    public void put(Context context) {
        if (context != null) {
            this.parameters.putAll(context.parameters);
        }
    }

    public Object remove(String key) {
        return this.parameters.remove(key);
    }

    public void remove() {
        this.parameters.clear();
    }

    public Map<String, Object> toMap() {
        return new HashMap<String, Object>(this.parameters);
    }

    public Iterator<Map.Entry<String, Object>> iterator() {
        return this.parameters.entrySet().iterator();
    }

    public Context clone() {
        Context result = new Context(this.parameters);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return this.parameters != null ? this.parameters.equals(context.parameters) : context.parameters == null;
    }

    public int hashCode() {
        return this.parameters != null ? this.parameters.hashCode() : 0;
    }
}

