/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.io;

import com.google.common.base.Charsets;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.joyqueue.toolkit.io.Compressor;

public abstract class Compressors {
    public static byte[] compress(String src, Compressor compressor) throws IOException {
        return Compressors.compress(src, Charsets.UTF_8, compressor);
    }

    public static byte[] compress(String src, Charset charset, Compressor compressor) throws IOException {
        if (src == null) {
            return null;
        }
        if (charset == null) {
            return Compressors.compress(src.getBytes(), compressor);
        }
        return Compressors.compress(src.getBytes(charset), compressor);
    }

    public static byte[] compress(byte[] buf, Compressor compressor) throws IOException {
        if (buf == null) {
            return null;
        }
        return Compressors.compress(buf, 0, buf.length, compressor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(byte[] buf, int offset, int size, Compressor compressor) throws IOException {
        if (buf == null) {
            return null;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(size);){
            compressor.compress(buf, offset, size, bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static byte[] decompress(byte[] buf, Compressor compressor) throws IOException {
        if (buf == null) {
            return null;
        }
        return Compressors.decompress(buf, 0, buf.length, compressor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] decompress(byte[] buf, int offset, int size, Compressor compressor) throws IOException {
        if (buf == null || buf.length == 0 || size <= 0 || offset >= buf.length) {
            return null;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(size * 4);){
            compressor.decompress(buf, offset, size, bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    public static String decompress(byte[] buf, Charset charset, Compressor compressor) throws IOException {
        if (buf == null || buf.length == 0) {
            return null;
        }
        return Compressors.decompress(buf, 0, buf.length, charset, compressor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(byte[] buf, int offset, int size, Charset charset, Compressor compressor) throws IOException {
        if (buf == null || buf.length == 0 || size <= 0 || offset >= buf.length) {
            return null;
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream(size * 4);){
            compressor.decompress(buf, offset, size, bos);
            String string = bos.toString(charset.toString());
            return string;
        }
    }
}

