/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.network.http;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import org.joyqueue.toolkit.URL;

public class Get {
    public static final int DEFAULT_TIMEOUT = 5000;
    public static final int DEFAULT_RETRY_TIMES = 1;
    protected int retryTimes;
    protected int connectionTimeout;
    protected int socketTimeout;
    protected String charset;

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(URL url) throws IOException {
        if (url == null) {
            return null;
        }
        if (this.retryTimes < 0) {
            this.retryTimes = 0;
        }
        if (this.socketTimeout < 0) {
            this.socketTimeout = 5000;
        }
        if (this.connectionTimeout < 0) {
            this.connectionTimeout = 5000;
        }
        if (this.charset == null || this.charset.isEmpty()) {
            this.charset = Charsets.UTF_8.name();
        }
        HttpURLConnection cnn = null;
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        for (int i = 0; i < this.retryTimes + 1; ++i) {
            try {
                java.net.URL ul = new java.net.URL(url.toString(true, true, new String[0]));
                cnn = (HttpURLConnection)ul.openConnection();
                cnn.setConnectTimeout(this.connectionTimeout);
                cnn.setReadTimeout(this.socketTimeout);
                cnn.setRequestProperty("charset", this.charset);
                cnn.setUseCaches(false);
                cnn.connect();
                if (cnn.getResponseCode() != 200) {
                    if (cnn.getResponseCode() == 404) {
                        i = this.retryTimes;
                    }
                    throw new IOException("http error,code=" + cnn.getResponseCode());
                }
                reader = new BufferedReader(new InputStreamReader(cnn.getInputStream()));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    builder.append(line);
                }
                String string = builder.toString();
                return string;
            }
            catch (IOException e) {
                if (i < this.retryTimes) continue;
                throw new IOException(url.toString(), e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                if (cnn != null) {
                    cnn.disconnect();
                }
            }
        }
        return null;
    }

    public static class Builder {
        protected int retryTimes = 1;
        protected int connectionTimeout = 5000;
        protected int socketTimeout = 5000;
        protected String charset = Charsets.UTF_8.name();

        public static Builder build() {
            return new Builder();
        }

        public Get create() {
            Get http = new Get();
            http.setCharset(this.charset);
            http.setRetryTimes(this.retryTimes);
            http.setConnectionTimeout(this.connectionTimeout);
            http.setSocketTimeout(this.socketTimeout);
            return http;
        }

        public Builder retryTimes(int retryTimes) {
            this.retryTimes = retryTimes;
            return this;
        }

        public Builder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder charset(String charset) {
            this.charset = charset;
            return this;
        }
    }
}

