/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.serialize;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.joyqueue.toolkit.io.Compressors;
import org.joyqueue.toolkit.io.Zip;

public abstract class AbstractSerializer {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String toProperties(Map<String, String> attributes) {
        if (attributes == null) {
            return "";
        }
        int count = 0;
        StringBuilder builder = new StringBuilder(100);
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            if (count > 0) {
                builder.append('\n');
            }
            AbstractSerializer.append(builder, entry.getKey(), true, true);
            builder.append('=');
            AbstractSerializer.append(builder, entry.getValue(), false, true);
            ++count;
        }
        return builder.toString();
    }

    protected static void append(StringBuilder builder, String value, boolean escapeSpace, boolean escapeUnicode) {
        int len = value.length();
        block8: for (int x = 0; x < len; ++x) {
            char aChar = value.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    builder.append('\\');
                    builder.append('\\');
                    continue;
                }
                builder.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        builder.append('\\');
                    }
                    builder.append(' ');
                    continue block8;
                }
                case '\t': {
                    builder.append('\\');
                    builder.append('t');
                    continue block8;
                }
                case '\n': {
                    builder.append('\\');
                    builder.append('n');
                    continue block8;
                }
                case '\r': {
                    builder.append('\\');
                    builder.append('r');
                    continue block8;
                }
                case '\f': {
                    builder.append('\\');
                    builder.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    builder.append('\\');
                    builder.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        builder.append('\\');
                        builder.append('u');
                        builder.append(hexDigit[aChar >> 12 & 0xF]);
                        builder.append(hexDigit[aChar >> 8 & 0xF]);
                        builder.append(hexDigit[aChar >> 4 & 0xF]);
                        builder.append(hexDigit[aChar & 0xF]);
                        continue block8;
                    }
                    builder.append(aChar);
                }
            }
        }
    }

    public static String readString(ByteBuffer in, int lengthSize, boolean compressed) throws Exception {
        int length;
        if (lengthSize == 1) {
            byte[] bytes = new byte[1];
            in.get(bytes);
            length = bytes[0] & 0xFF;
        } else {
            length = lengthSize == 2 ? in.getShort() : in.getInt();
        }
        return AbstractSerializer.read(in, length, compressed, "UTF-8");
    }

    public static String read(ByteBuffer in, int length, boolean compressed, String charset) throws Exception {
        if (length <= 0) {
            return "";
        }
        byte[] bytes = AbstractSerializer.readBytes(in, length);
        try {
            if (compressed) {
                bytes = Compressors.decompress(bytes, 0, bytes.length, Zip.INSTANCE);
            }
            if (charset == null || charset.isEmpty()) {
                charset = "UTF-8";
            }
            return new String(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            return new String(bytes);
        }
    }

    public static byte[] readBytes(ByteBuffer in, int length) {
        if (in == null || length <= 0) {
            return new byte[0];
        }
        int len = in.remaining();
        if (len == 0) {
            return new byte[0];
        }
        if (length < len) {
            len = length;
        }
        byte[] bytes = new byte[len];
        in.get(bytes);
        return bytes;
    }

    public static Map<String, String> toStringMap(String text) throws IOException {
        if (text == null || text.isEmpty()) {
            return null;
        }
        Properties properties = new Properties();
        properties.load(new StringReader(text));
        return new HashMap<Object, Object>(properties);
    }

    public static String readString(ByteBuffer in) throws Exception {
        return AbstractSerializer.readString(in, 1, false);
    }

    public static String readString(ByteBuffer in, int lengthSize) throws Exception {
        return AbstractSerializer.readString(in, lengthSize, false);
    }

    public static byte[] getBytes(String value, Charset charset) {
        if (value == null) {
            return new byte[0];
        }
        byte[] bytes = charset == null ? value.getBytes(Charsets.UTF_8) : value.getBytes(charset);
        return bytes;
    }
}

