/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.service;

import org.joyqueue.toolkit.exception.Abnormity;
import org.joyqueue.toolkit.lang.Online;
import org.joyqueue.toolkit.service.Service;

public class ServiceThread
implements Runnable,
Abnormity,
Online {
    public static final long SLEEP_ON_ERROR = 2000L;
    protected Service parent;
    protected long interval;
    protected long sleepOnError = 2000L;

    public ServiceThread(Service parent) {
        this(parent, 0L, 2000L);
    }

    public ServiceThread(Service parent, long interval) {
        this(parent, interval, 2000L);
    }

    public ServiceThread(Service parent, long interval, long sleepOnError) {
        if (parent == null) {
            throw new IllegalArgumentException("parent can not be null");
        }
        this.parent = parent;
        this.interval = interval;
        this.sleepOnError = sleepOnError;
    }

    @Override
    public boolean onException(Throwable e) {
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.parent.isStarted() && !Thread.currentThread().isInterrupted();
    }

    public long getInterval() {
        return this.interval;
    }

    protected void execute() throws Exception {
    }

    protected void await(long time) {
        if (time > 0L) {
            this.parent.await(time);
        }
    }

    protected void stop() {
    }

    @Override
    public void run() {
        long interval = this.interval;
        while (this.isStarted()) {
            try {
                interval = this.getInterval();
                if (interval > 0L) {
                    this.await(interval);
                    if (!this.isStarted()) break;
                }
                this.execute();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                if (!this.onException(e)) break;
                if (interval > 0L || this.sleepOnError <= 0L) continue;
                this.await(this.sleepOnError);
            }
        }
        this.stop();
    }
}

