/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.stat;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.joyqueue.toolkit.stat.TPStat;

public class TPStatBuffer
implements Serializable {
    protected static final int LENGTH = 256;
    protected AtomicReferenceArray<AtomicLongArray> timer;
    protected AtomicReference<ConcurrentMap<Integer, AtomicLong>> outstrip;
    protected AtomicLong recordTotal = new AtomicLong(0L);
    protected AtomicLong successTotal = new AtomicLong(0L);
    protected AtomicLong errorTotal = new AtomicLong(0L);
    protected AtomicLong sizeTotal = new AtomicLong(0L);
    protected AtomicLong timeTotal = new AtomicLong(0L);
    protected int maxTime;
    protected int length;
    protected int exponent;

    public TPStatBuffer() {
        this(256);
    }

    public TPStatBuffer(int length) {
        if (length < 1) {
            throw new IllegalArgumentException("length must be greater than 0");
        }
        int cap = 1;
        int exponent = 0;
        while (length > cap) {
            cap <<= 1;
            ++exponent;
        }
        this.length = cap;
        this.exponent = exponent;
        this.timer = new AtomicReferenceArray(cap);
        this.outstrip = new AtomicReference();
        this.maxTime = cap * cap - 1;
    }

    public void clear() {
        this.timer = new AtomicReferenceArray(this.length);
        this.successTotal.set(0L);
        this.errorTotal.set(0L);
        this.sizeTotal.set(0L);
        this.timeTotal.set(0L);
        ConcurrentMap<Integer, AtomicLong> exceeds = this.outstrip.get();
        if (exceeds != null) {
            exceeds.clear();
        }
    }

    public void success(int time, int count, int records, long size) {
        if (time < 0 || count <= 0) {
            return;
        }
        this.successTotal.addAndGet(count);
        if (records > 0) {
            this.recordTotal.addAndGet(records);
        }
        if (size > 0L) {
            this.sizeTotal.addAndGet(size);
        }
        if (time > 0) {
            this.timeTotal.addAndGet(time * count);
        }
        int maxIndex = this.length - 1;
        if (time > this.maxTime) {
            AtomicLong counts;
            ConcurrentMap<Integer, AtomicLong> exceeds = this.outstrip.get();
            if (exceeds == null && !this.outstrip.compareAndSet(null, exceeds = new ConcurrentSkipListMap<Integer, AtomicLong>())) {
                exceeds = this.outstrip.get();
            }
            if ((counts = (AtomicLong)exceeds.get(time)) == null) {
                counts = new AtomicLong();
                AtomicLong old = exceeds.putIfAbsent(time, counts);
                if (old != null) {
                    counts = old;
                }
            }
            counts.addAndGet(count);
        } else {
            int i = time >> this.exponent;
            int j = time & maxIndex;
            AtomicLongArray v = this.timer.get(i);
            if (v == null && !this.timer.compareAndSet(i, null, v = new AtomicLongArray(this.length))) {
                v = this.timer.get(i);
            }
            v.addAndGet(j, count);
        }
    }

    public void success(int records, long size, int time) {
        this.success(time, 1, records, size);
    }

    public void error() {
        this.errorTotal.incrementAndGet();
    }

    public void error(int count) {
        this.errorTotal.addAndGet(count);
    }

    public TPStat getTPStat() {
        int time;
        TPStat stat = new TPStat();
        stat.setSuccess(this.successTotal.get());
        stat.setError(this.errorTotal.get());
        stat.setCount(this.recordTotal.get());
        stat.setTime(this.timeTotal.get());
        stat.setSize(this.sizeTotal.get());
        if (stat.getSuccess() <= 0L) {
            return stat;
        }
        int min = -1;
        int max = -1;
        int tp999 = (int)Math.floor((double)stat.getSuccess() * 99.9 / 100.0);
        int tp99 = (int)Math.floor((double)stat.getSuccess() * 99.0 / 100.0);
        int tp90 = (int)Math.floor((double)stat.getSuccess() * 90.0 / 100.0);
        int tp50 = (int)Math.floor((double)stat.getSuccess() * 50.0 / 100.0);
        long prev = 0L;
        long pos = 0L;
        for (int i = 0; i < this.length; ++i) {
            AtomicLongArray v = this.timer.get(i);
            if (v == null) continue;
            for (int j = 0; j < this.length; ++j) {
                long count = v.get(j);
                if (count <= 0L) continue;
                time = i * this.length + j;
                pos = prev + count;
                if (min == -1) {
                    min = time;
                }
                if (max == -1 || time > max) {
                    max = time;
                }
                if (prev < (long)tp50 && pos >= (long)tp50) {
                    stat.setTp50(time);
                }
                if (prev < (long)tp90 && pos >= (long)tp90) {
                    stat.setTp90(time);
                }
                if (prev < (long)tp99 && pos >= (long)tp99) {
                    stat.setTp99(time);
                }
                if (prev < (long)tp999 && pos >= (long)tp999) {
                    stat.setTp999(time);
                }
                prev = pos;
            }
        }
        ConcurrentMap<Integer, AtomicLong> exceeds = this.outstrip.get();
        if (exceeds != null) {
            for (Map.Entry entry : exceeds.entrySet()) {
                time = (Integer)entry.getKey();
                pos = prev + ((AtomicLong)entry.getValue()).get();
                if (min == -1) {
                    min = time;
                }
                if (max == -1 || time > max) {
                    max = time;
                }
                if (prev < (long)tp50 && pos >= (long)tp50) {
                    stat.setTp50(time);
                }
                if (prev < (long)tp90 && pos >= (long)tp90) {
                    stat.setTp90(time);
                }
                if (prev < (long)tp99 && pos >= (long)tp99) {
                    stat.setTp99(time);
                }
                if (prev < (long)tp999 && pos >= (long)tp999) {
                    stat.setTp999(time);
                }
                prev = pos;
            }
        }
        stat.setMin(min);
        stat.setMax(max);
        return stat;
    }
}

