/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.util;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class ASMUtils {
    private static final ConcurrentMap<String, ClassReader> classReaderCache = Maps.newConcurrentMap();
    private static final ConcurrentMap<Class<?>, ConcurrentMap<String, Map<String, Class<?>>>> paramsCache = Maps.newConcurrentMap();

    public static Map<String, Class<?>> getParams(Class<?> type, String methodName) {
        Map<String, Class<?>> result;
        ConcurrentMap oldMethodParamsCache;
        ConcurrentMap<String, Map<String, Class<Object>>> methodParamsCache = (ConcurrentHashMap)paramsCache.get(type);
        if (methodParamsCache == null && (oldMethodParamsCache = (ConcurrentMap)paramsCache.putIfAbsent(type, methodParamsCache = new ConcurrentHashMap())) != null) {
            methodParamsCache = oldMethodParamsCache;
        }
        if ((result = (Map<String, Class<?>>)methodParamsCache.get(methodName)) != null) {
            return result;
        }
        result = ASMUtils.doGetParams(type, methodName);
        methodParamsCache.put(methodName, result);
        return result;
    }

    protected static Map<String, Class<?>> doGetParams(Class<?> type, final String methodName) {
        if (type.isInterface()) {
            throw new UnsupportedOperationException();
        }
        final Method[] targetMethod = new Method[1];
        for (Method method : type.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            targetMethod[0] = method;
            break;
        }
        if (targetMethod[0] == null) {
            return Collections.emptyMap();
        }
        final LinkedHashMap result = Maps.newLinkedHashMap();
        ASMUtils.getClassReader(type).accept(new ClassVisitor(393216){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                if (!name.equals(methodName)) {
                    return super.visitMethod(access, name, descriptor, signature, exceptions);
                }
                return new MethodVisitor(393216){

                    public void visitLocalVariable(String name, String descriptor, String signature, Label start, Label end, int index) {
                        if (!name.equals("this") && index - 1 <= targetMethod[0].getParameterTypes().length) {
                            result.put(name, ASMUtils.convertType(descriptor));
                        }
                        super.visitLocalVariable(name, descriptor, signature, start, end, index);
                    }
                };
            }
        }, 0);
        return result;
    }

    public static Class<?> convertType(String type) {
        try {
            if (type.startsWith("L") && type.endsWith(";")) {
                return Class.forName(type.substring(1, type.length() - 1).replace("/", "."));
            }
            switch (type) {
                case "I": {
                    return Integer.class;
                }
                case "S": {
                    return Short.class;
                }
                case "B": {
                    return Byte.class;
                }
                case "F": {
                    return Float.class;
                }
                case "D": {
                    return Double.class;
                }
                case "J": {
                    return Long.class;
                }
                case "Z": {
                    return Boolean.class;
                }
            }
            throw new UnsupportedOperationException(type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static ClassReader getClassReader(Class<?> type) {
        String className = type.getName();
        ClassReader classReader = (ClassReader)classReaderCache.get(className);
        if (classReader == null) {
            try {
                classReader = new ClassReader(className.replace(".", "/"));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ClassReader oldClassReader = classReaderCache.putIfAbsent(className, classReader);
            if (oldClassReader != null) {
                classReader = oldClassReader;
            }
        }
        return classReader;
    }
}

