/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.validate;

import java.lang.annotation.Annotation;
import org.joyqueue.toolkit.validate.ValidateException;
import org.joyqueue.toolkit.validate.Validator;
import org.joyqueue.toolkit.validate.annotation.Range;

public class RangeValidator
implements Validator {
    public static final RangeValidator INSTANCE = new RangeValidator();

    @Override
    public void validate(Object target, Annotation annotation, Validator.Value value) throws ValidateException {
        Range range = (Range)annotation;
        Long result = null;
        if (value.value != null && value.value instanceof Number) {
            result = ((Number)value.value).longValue();
        }
        if (result == null || result < range.min() || result > range.max()) {
            if (range.message() == null || range.message().isEmpty()) {
                throw new ValidateException(String.format("%s is not in range[%d,%d]", value.name, range.min(), range.max()));
            }
            throw new ValidateException(String.format(range.message(), value.name, range.min(), range.max()));
        }
    }
}

