/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.vm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.joyqueue.toolkit.service.Service;
import org.joyqueue.toolkit.vm.JVMMonitorService;
import org.joyqueue.toolkit.vm.MemoryStat;
import sun.misc.SharedSecrets;

public class GarbageCollectorMonitor
extends Service
implements JVMMonitorService {
    @Override
    public void addGCEventListener(NotificationListener listener) {
        List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcbean : gcbeans) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcbean);
            emitter.addNotificationListener(listener, null, null);
        }
    }

    @Override
    public MemoryStat memSnapshot() {
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heap = memBean.getHeapMemoryUsage();
        MemoryUsage nonHeap = memBean.getNonHeapMemoryUsage();
        MemoryStat stat = new MemoryStat();
        stat.setHeapMax(heap.getMax());
        stat.setHeapInit(heap.getInit());
        stat.setHeapCommitted(heap.getCommitted());
        stat.setHeapUsed(heap.getUsed());
        stat.setNonHeapInit(nonHeap.getInit());
        stat.setNonHeapMax(nonHeap.getMax());
        stat.setNonHeapUsed(nonHeap.getUsed());
        stat.setNonHeapCommitted(nonHeap.getCommitted());
        stat.setDirectBufferSize(SharedSecrets.getJavaNioAccess().getDirectBufferPool().getMemoryUsed());
        return stat;
    }
}

