# 概念

JoyQueue采用的消息模型是标准的“发布-订阅模型（Publish-Subscribe Pattern）”，本文对JoyQueue中使用的消息模型和涉及到的概念做简明的介绍。

## 基础概念

### 主题/Topic

主题是发布和订阅消息的基本单位。

### 分区/Partition

主题中包含一个或多个分区。一个主题的多个分区可以分布在多个Broker上，用于并行的生产和消费，提升主题总体的吞吐量。主题中的分区和动态的增加或者减少，实现水平扩缩绒。

### Broker/JoyQueue Server

Broker是JoyQueue的服务端进程，也成为JoyQueue Server。

### 应用/App

应用是JoyQueue的使用者，可以是生产者也可以是消费者，一个应用可以有多个实例。

### 生产者/Producer

即消息发送端的应用程序。

### 消费者/Consumer

消息接收端的应用程序。

## 高级概念

### 分区组

分区组包含一组分区，同一组分区分布在同一个Broker，共享一个复制集群。

### Broker分组

Broker分组包含一组Broker，主要目的是便于管理Broker。

### 命名空间

即主题的命名空间，创建主题时可以指定命名空间，同一命名空间下主题具有唯一性。

### 消费组

在消费时，默认一个应用消费主题一份完整消息，如果应用的启动多个消费者实例，那这些实例之间是竞争消费，每条消息最多只能被一个实例消费。

如果一个应用需要同时消费同一主题多次，可以通过配置多个消费组来实现。例如，同一个应用，线上环境和预发环境都希望能各自完整消费同一主题的消息，就可以各自配置一个消费组。每个消费组包含一份完整的消息。
