# 性能

我们设计了简单的测试场景，来寻找JoyQueue的极限性能。

## 测试环境

实验中，采用了一台服务器部署JoyQueue Server，服务器的配置如下：

硬件 | 配置
-- | --
CPU | Intel(R) Xeon(R) CPU E5-2620 v4 @ 2.10GHz with 8 cores x 2
内存 | 32GB x 8 RAM
SSD | 960GB x 6 RAID5  
网卡 | 10 Gigabit Ethernet

客户端均部署在Docker中，每个Docker配置为：

硬件 | 配置
-- | --
CPU | 2 Cores
内存 | 4GB RAM
SSD | N/A  
网卡 | 10 Gigabit Ethernet

## 测试场景

我们选择了2个最典型的场景，来测试JoyQueue的极限处理能力。

### 场景一： 在线业务场景

这个场景模拟典型的在线业务使用JoyQueue的方式。例如，电商的订单服务在收到APP的下单请求，创建订单成功后，发送一条消息，用于清空购物车、统计分析等后续的异步处理。

这种场景下，一般每次只发送一条消息，采用同步方式发送，严格要求消息发送的可靠性，要求较低的发送时延。

### 场景二：流计算场景

这个场景模拟使用流计算处理海量数据时，使用JoyQueue的方式。例如，实时收集前端的埋点数据，汇总到JoyQueue中，再由流计算任务消费这些数据进行实时计算。

这种场景下，需要实时处理海量数据，希望JoyQueue有较高的吞吐量，对时延不敏感，一般采用异步批量收发。

## 测试方案

场景 | 发送方式 | 批量大小 | 消息压缩方式 | 测试消息大小 | 分区数量 | 客户端
-- | -- | -- | -- | -- | -- | -- 
**在线业务场景** | 同步 | 1 | 不压缩 | 1KB | 200 | joyqueue-client-4.1.0
**流计算场景** | 异步 | 100 | LZ4 | 1KB | 200 | kafka-clients-2.1.1

我们在测试过程中采用梯度加压的方式逐步增加消息生产并发，寻找JoyQueue性能的极限。

## 测试结果

### 生产性能

生产性能的测试结果如下表：

| 场景 | QPS | 并发数量| 时延 AVG/TP99/TP999 (ms) | 失败率(%)
| :----:| :----:|:----: |:----: |:----:|
|**在线业务场景**| **510, 924** | 400| 1/4/8 | 0
|**流计算场景** | **32, 961, 776** | 900 | N/A | 0

测试过程中的监控的服务器资源使用情况一并记录如下表：

| 场景 | CPU利用率(%) | CPU负载 |内存使用率(%)| 网络流入/流出速率(MB/s) | 磁盘繁忙率(%) |
| :----:| :----: |:----: |:----:|:----:|:----:|
|**在线业务场景**| 61 | 32.1 |12.22 |587.1/41.56| 42
|**流计算场景** | 19 | 5.52 |11.88 |886.11/4.63 |53

### 消费性能

我们在上述生产性能达到极限的情况下，同时增加了一组200并发（与分区数量相同）的消费，消费者只拉取消息，无任何消费逻辑，测试结果表明：

* 消费的速度 = 生产速度，无积压；
* 加入消费后，对生产的性能没有影响。
