/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store.message;

import java.nio.ByteBuffer;
import org.joyqueue.store.message.MessageParser;

public class BatchMessageParser {
    private static final int BATCH_FLAG_BYTE_INDEX = MessageParser.SYS;
    private static final int BATCH_FLAG_BIT_INDEX = 4;
    private static final int BATCH_SIZE_INDEX = MessageParser.FLAG;

    public static boolean isBatch(ByteBuffer msg) {
        return 1 == MessageParser.getBit(msg, BATCH_FLAG_BYTE_INDEX, 4);
    }

    public static void setBatch(ByteBuffer msg, boolean isBatch) {
        MessageParser.setBit(msg, BATCH_FLAG_BYTE_INDEX, 4, isBatch);
    }

    public static short getBatchSize(ByteBuffer msg) {
        return MessageParser.getShort(msg, BATCH_SIZE_INDEX);
    }

    public static void setBatchSize(ByteBuffer msg, short batchSize) {
        MessageParser.setShort(msg, BATCH_SIZE_INDEX, batchSize);
    }
}

