/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.store.message;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.joyqueue.store.message.ParseAttributeException;
import org.joyqueue.toolkit.time.SystemClock;

public class MessageParser {
    public static final int VARIABLE_LENGTH_1 = -1;
    public static final int VARIABLE_LENGTH_2 = -2;
    public static final int VARIABLE_LENGTH_4 = -4;
    public static final int FIXED_LENGTH_1 = 1;
    public static final int FIXED_LENGTH_2 = 2;
    public static final int FIXED_LENGTH_4 = 4;
    public static final int FIXED_LENGTH_8 = 8;
    public static final int FIXED_LENGTH_16 = 16;
    private static int offset = 0;
    private static int firstVarOffset = -1;
    private static int firstVarIndex = -1;
    private static final List<Attribute> attributeList = new LinkedList<Attribute>();
    public static final int LENGTH = MessageParser.createAttribute("LENGTH", 4);
    public static final int PARTITION = MessageParser.createAttribute("PARTITION", 2);
    public static final int INDEX = MessageParser.createAttribute("INDEX", 8);
    public static final int TERM = MessageParser.createAttribute("TERM", 4);
    public static final int MAGIC = MessageParser.createAttribute("MAGIC", 2);
    public static final int SYS = MessageParser.createAttribute("SYS", 2);
    public static final int PRIORITY = MessageParser.createAttribute("PRIORITY", 1);
    public static final int CLIENT_IP = MessageParser.createAttribute("CLIENT_IP", 16);
    public static final int CLIENT_TIMESTAMP = MessageParser.createAttribute("CLIENT_TIMESTAMP", 8);
    public static final int STORAGE_TIMESTAMP = MessageParser.createAttribute("STORAGE_TIMESTAMP", 4);
    public static final int CRC = MessageParser.createAttribute("CRC", 8);
    public static final int FLAG = MessageParser.createAttribute("FLAG", 2);
    public static final int BODY = MessageParser.createAttribute("BODY", -4);
    public static final int BIZ_ID = MessageParser.createAttribute("BIZ_ID", -1);
    public static final int PROPERTY = MessageParser.createAttribute("PROPERTY", -2);
    public static final int EXPAND = MessageParser.createAttribute("EXPAND", -4);
    public static final int APP = MessageParser.createAttribute("APP", -1);
    private static final Attribute[] attributes = attributeList.toArray(new Attribute[0]);

    public static int getFixedAttributesLength() {
        return firstVarOffset;
    }

    public static byte getByte(ByteBuffer messageBuffer, int offset) {
        return messageBuffer.get(messageBuffer.position() + offset);
    }

    public static void setByte(ByteBuffer messageBuffer, int offset, byte value) {
        messageBuffer.put(messageBuffer.position() + offset, value);
    }

    public static short getShort(ByteBuffer messageBuffer, int offset) {
        return messageBuffer.getShort(messageBuffer.position() + offset);
    }

    public static void setShort(ByteBuffer messageBuffer, int offset, short value) {
        messageBuffer.putShort(messageBuffer.position() + offset, value);
    }

    public static int getBit(ByteBuffer messageBuffer, int byteOffset, int bitOffset) {
        byte b = MessageParser.getByte(messageBuffer, byteOffset);
        return b >> bitOffset & 1;
    }

    public static void setBit(ByteBuffer messageBuffer, int byteOffset, int bitOffset, boolean bitValue) {
        byte b = MessageParser.getByte(messageBuffer, byteOffset);
        b = bitValue ? (byte)(b | 1 << bitOffset) : (byte)(b & ~(1 << bitOffset));
        MessageParser.setByte(messageBuffer, byteOffset, b);
    }

    public static int getInt(ByteBuffer messageBuffer, int offset) {
        return messageBuffer.getInt(messageBuffer.position() + offset);
    }

    public static void setInt(ByteBuffer messageBuffer, int offset, int value) {
        messageBuffer.putInt(messageBuffer.position() + offset, value);
    }

    public static long getLong(ByteBuffer messageBuffer, int offset) {
        return messageBuffer.getLong(messageBuffer.position() + offset);
    }

    public static void setLong(ByteBuffer messageBuffer, int offset, long value) {
        messageBuffer.putLong(messageBuffer.position() + offset, value);
    }

    public static ByteBuffer getByteBuffer(ByteBuffer messageBuffer, int relativeOffset) {
        int offset = firstVarOffset;
        for (int index = firstVarIndex; index < firstVarIndex - relativeOffset; ++index) {
            int varLength = attributes[index].getLength();
            offset += MessageParser.getVariableAttributeLength(messageBuffer, varLength, offset);
            offset -= varLength;
        }
        int varLength = attributes[firstVarIndex - relativeOffset].getLength();
        int length = MessageParser.getVariableAttributeLength(messageBuffer, varLength, offset);
        offset -= varLength;
        if (length < 0) {
            throw new ParseAttributeException("Invalid offset: " + relativeOffset);
        }
        ByteBuffer byteBuffer = messageBuffer.slice();
        byteBuffer.position(offset);
        byteBuffer.limit(offset + length);
        return byteBuffer;
    }

    public static byte[] getBytes(ByteBuffer messageBuffer, int relativeOffset) {
        ByteBuffer byteBuffer = MessageParser.getByteBuffer(messageBuffer, relativeOffset);
        ByteBuffer arrayBuffer = ByteBuffer.allocate(byteBuffer.remaining());
        arrayBuffer.put(byteBuffer);
        return arrayBuffer.array();
    }

    public static ByteBuffer build(byte[][] variableAttributes) {
        if (variableAttributes.length != attributes.length - firstVarIndex) {
            throw new ParseAttributeException("Length of parameter variableAttributes should be equals the count of variable attributes : " + (attributes.length - firstVarIndex));
        }
        int length = firstVarOffset;
        for (int i = 0; i < variableAttributes.length; ++i) {
            byte[] attributeValue = variableAttributes[i];
            Attribute attribute = attributes[firstVarIndex + i];
            length += attributeValue.length - attribute.getLength();
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(length);
        MessageParser.setInt(byteBuffer, LENGTH, length);
        byteBuffer.position(firstVarOffset);
        for (int i = 0; i < variableAttributes.length; ++i) {
            byte[] attributeValue = variableAttributes[i];
            Attribute attribute = attributes[firstVarIndex + i];
            switch (attribute.getLength()) {
                case -1: {
                    byteBuffer.put((byte)attributeValue.length);
                    break;
                }
                case -2: {
                    byteBuffer.putShort((short)attributeValue.length);
                    break;
                }
                case -4: {
                    byteBuffer.putInt(attributeValue.length);
                    break;
                }
                default: {
                    throw new ParseAttributeException("Invalid length: " + length);
                }
            }
            byteBuffer.put(attributeValue);
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    public static String getString(ByteBuffer messageBuffer) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        StringBuilder stringBuilder = new StringBuilder();
        long clientDate = 0L;
        block14: for (Attribute attribute : attributes) {
            stringBuilder.append(attribute.getName()).append("(");
            if (attribute.getLength() >= 0) {
                stringBuilder.append(attribute.getLength()).append("): ");
            }
            switch (attribute.getLength()) {
                case 1: {
                    try {
                        byte b = MessageParser.getByte(messageBuffer, attribute.getOffset());
                        stringBuilder.append(String.format("%02X", b)).append(String.format("(%d)", new Byte(b).intValue())).append("\n");
                    }
                    catch (Exception e) {
                        stringBuilder.append("Exception:").append(e).append("\n");
                    }
                    continue block14;
                }
                case 2: {
                    try {
                        short s = MessageParser.getShort(messageBuffer, attribute.getOffset());
                        stringBuilder.append(s).append("\n");
                    }
                    catch (Exception e) {
                        stringBuilder.append("Exception:").append(e).append("\n");
                    }
                    continue block14;
                }
                case 4: {
                    try {
                        int ii = MessageParser.getInt(messageBuffer, attribute.getOffset());
                        stringBuilder.append(ii);
                        if ("STORAGE_TIMESTAMP".equals(attribute.getName())) {
                            stringBuilder.append(" (").append(sdf.format(new Date(clientDate + (long)ii))).append(")");
                        }
                        stringBuilder.append("\n");
                    }
                    catch (Exception e) {
                        stringBuilder.append("Exception:").append(e).append("\n");
                    }
                    continue block14;
                }
                case 8: {
                    try {
                        long l = MessageParser.getLong(messageBuffer, attribute.getOffset());
                        stringBuilder.append(l);
                        if ("CLIENT_TIMESTAMP".equals(attribute.getName())) {
                            clientDate = l;
                            stringBuilder.append(" (").append(sdf.format(new Date(l))).append(")");
                        }
                        stringBuilder.append("\n");
                    }
                    catch (Exception e) {
                        stringBuilder.append("Exception:").append(e).append("\n");
                    }
                    continue block14;
                }
                default: {
                    MessageParser.appendBytes(messageBuffer, stringBuilder, attribute);
                }
            }
        }
        return stringBuilder.toString();
    }

    private static void appendBytes(ByteBuffer messageBuffer, StringBuilder stringBuilder, Attribute attribute) {
        try {
            byte[] bytes;
            if (attribute.getLength() < 0) {
                bytes = MessageParser.getBytes(messageBuffer, attribute.getOffset());
                stringBuilder.append(bytes.length);
                stringBuilder.append("): ");
            } else {
                bytes = MessageParser.getBytes(messageBuffer, attribute);
            }
            stringBuilder.append("\n\tHex: ");
            for (int j = 0; j < bytes.length && j < 32; ++j) {
                stringBuilder.append(String.format("0x%02X ", bytes[j]));
            }
            if (bytes.length > 32) {
                stringBuilder.append("...");
            }
            stringBuilder.append("\n\tString: ").append(new String(bytes, StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            stringBuilder.append("Exception:").append(e);
        }
        stringBuilder.append("\n");
    }

    private static byte[] getBytes(ByteBuffer messageBuffer, Attribute attribute) {
        ByteBuffer byteBuffer = messageBuffer.slice();
        byteBuffer.position(byteBuffer.position() + attribute.getOffset());
        byteBuffer.limit(byteBuffer.position() + attribute.getLength());
        ByteBuffer buffer = ByteBuffer.allocate(attribute.length);
        buffer.put(byteBuffer);
        buffer.flip();
        byte[] bytes = buffer.array();
        return bytes;
    }

    private static int getVariableAttributeLength(ByteBuffer messageBuffer, int length, int offset) {
        switch (length) {
            case -1: {
                return messageBuffer.get(offset);
            }
            case -2: {
                return messageBuffer.getShort(offset);
            }
            case -4: {
                return messageBuffer.getInt(offset);
            }
        }
        throw new ParseAttributeException("Invalid length: " + length);
    }

    private static int createAttribute(String name, int length) {
        Attribute attribute = new Attribute(name, length);
        if (attribute.length >= 0) {
            if (offset < 0) {
                throw new ParseAttributeException("Can not add a fixed length attribute after any variable length attribute!");
            }
            attribute.setOffset(offset);
            offset += length;
        } else {
            if (firstVarOffset < 0) {
                firstVarOffset = offset;
                firstVarIndex = attributeList.size();
                offset = -1;
            }
            attribute.setOffset(firstVarIndex - attributeList.size());
        }
        attributeList.add(attribute);
        return attribute.getOffset();
    }

    public static void main(String[] args) {
        byte[] body = "This is body!".getBytes(StandardCharsets.UTF_8);
        byte[] biz_id = new byte[8];
        Arrays.fill(biz_id, (byte)37);
        byte[] property = "This is property!".getBytes(StandardCharsets.UTF_8);
        byte[] expand = "This is expand!".getBytes(StandardCharsets.UTF_8);
        byte[] app = new byte[8];
        Arrays.fill(app, (byte)33);
        byte[][] varAtts = new byte[][]{body, biz_id, property, expand, app};
        ByteBuffer byteBuffer = MessageParser.build(varAtts);
        MessageParser.setLong(byteBuffer, CLIENT_TIMESTAMP, SystemClock.now());
        MessageParser.setLong(byteBuffer, INDEX, 23L);
        MessageParser.setByte(byteBuffer, PRIORITY, (byte)6);
        MessageParser.setShort(byteBuffer, PARTITION, (short)26);
        MessageParser.setInt(byteBuffer, TERM, 127);
        System.out.println(MessageParser.getString(byteBuffer));
    }

    static class Attribute {
        private final int length;
        private final String name;
        private int offset = -1;

        Attribute(String name, int length) {
            this.name = name;
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public String getName() {
            return this.name;
        }
    }
}

