/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;

public final class URL
implements Serializable {
    public static final String FILE = "file";
    private static final long serialVersionUID = -1985165475234910535L;
    private final String protocol;
    private final String username;
    private final String password;
    private final String host;
    private final int port;
    private final String path;
    private final Map<String, String> parameters;

    protected URL() {
        this.protocol = null;
        this.username = null;
        this.password = null;
        this.host = null;
        this.port = 0;
        this.path = null;
        this.parameters = null;
    }

    public URL(String protocol, String host, int port) {
        this(protocol, null, null, host, port, null, null);
    }

    public URL(String protocol, String host, int port, Map<String, String> parameters) {
        this(protocol, null, null, host, port, null, parameters);
    }

    public URL(String protocol, String host, int port, String path) {
        this(protocol, null, null, host, port, path, null);
    }

    public URL(String protocol, String host, int port, String path, Map<String, String> parameters) {
        this(protocol, null, null, host, port, path, parameters);
    }

    public URL(String protocol, String username, String password, String host, int port, String path) {
        this(protocol, username, password, host, port, path, null);
    }

    public URL(String protocol, String username, String password, String host, int port, String path, Map<String, String> parameters) {
        if ((username == null || username.isEmpty()) && password != null && password.length() > 0) {
            throw new IllegalArgumentException("Invalid url, password without username!");
        }
        this.protocol = protocol;
        this.username = username;
        this.password = password;
        this.host = host;
        this.port = port < 0 ? 0 : port;
        this.path = path;
        while (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        parameters = parameters == null ? new HashMap<String, String>() : new HashMap<String, String>(parameters);
        this.parameters = Collections.unmodifiableMap(parameters);
    }

    public static String[] split(String url) {
        return URL.split(url, ';');
    }

    public static String[] split(String url, char delimeter) {
        if (url == null || url.isEmpty()) {
            return new String[0];
        }
        ArrayList<String> urls = new ArrayList<String>();
        int braces = 0;
        String value = null;
        char[] chars = url.toCharArray();
        StringBuilder builder = new StringBuilder(url.length());
        for (char ch : chars) {
            if (ch == delimeter && braces == 0) {
                if (builder.length() <= 0) continue;
                value = builder.toString().trim();
                if (!value.isEmpty()) {
                    urls.add(value);
                }
                builder.delete(0, builder.length());
                continue;
            }
            builder.append(ch);
            if (ch == '(') {
                ++braces;
                continue;
            }
            if (ch != ')' || braces <= 0) continue;
            --braces;
        }
        if (builder.length() > 0 && !(value = builder.toString().trim()).isEmpty()) {
            urls.add(value);
        }
        return urls.toArray(new String[urls.size()]);
    }

    public static URL valueOf(String url) {
        if (url == null) {
            return null;
        }
        if ((url = url.trim()).isEmpty()) {
            return null;
        }
        String protocol = null;
        String username = null;
        String password = null;
        String host = null;
        int port = 0;
        String path = null;
        HashMap<String, String> parameters = null;
        int j = 0;
        int i = url.indexOf(41);
        i = i >= 0 ? url.indexOf(63, i) : url.indexOf("?");
        if (i >= 0) {
            if (i < url.length() - 1) {
                String[] parts = url.substring(i + 1).split("\\&");
                parameters = new HashMap<String, String>();
                for (String part : parts) {
                    if ((part = part.trim()).length() <= 0) continue;
                    j = part.indexOf(61);
                    if (j > 0) {
                        if (j == part.length() - 1) {
                            parameters.put(part.substring(0, j), "");
                            continue;
                        }
                        parameters.put(part.substring(0, j), part.substring(j + 1));
                        continue;
                    }
                    if (j != -1) continue;
                    parameters.put(part, part);
                }
            }
            url = url.substring(0, i);
        }
        if ((i = url.indexOf("://")) > 0) {
            protocol = url.substring(0, i);
            url = url.substring(i + 3);
        } else if (i < 0 && (i = url.indexOf(":/")) > 0) {
            protocol = url.substring(0, i);
            url = url.substring(i + 1);
        }
        if (protocol == null || protocol.isEmpty()) {
            throw new IllegalStateException("url missing protocol: " + url);
        }
        if (protocol.equals(FILE)) {
            path = url;
            url = "";
        } else {
            i = url.lastIndexOf(41);
            i = i >= 0 ? url.indexOf(47, i) : url.indexOf("/");
            if (i >= 0) {
                path = url.substring(i + 1);
                url = url.substring(0, i);
            }
        }
        i = url.indexOf(40);
        if (i >= 0) {
            j = url.lastIndexOf(41);
            url = j >= 0 ? url.substring(i + 1, j) : url.substring(i + 1);
        } else {
            String[] values;
            i = url.indexOf("@");
            if (i >= 0) {
                username = url.substring(0, i);
                j = username.indexOf(":");
                if (j >= 0) {
                    password = username.substring(j + 1);
                    username = username.substring(0, j);
                }
                url = url.substring(i + 1);
            }
            if ((values = url.split(":")).length == 2) {
                port = Integer.parseInt(values[1]);
                url = values[0];
            }
        }
        if (!url.isEmpty()) {
            host = url;
        }
        return new URL(protocol, username, password, host, port, path, parameters);
    }

    public static String encode(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            return null;
        }
    }

    public static String decode(String value) {
        if (value == null || value.isEmpty()) {
            return "";
        }
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException ignored) {
            return null;
        }
    }

    public String getProtocol() {
        return this.protocol;
    }

    public URL setProtocol(String protocol) {
        return new URL(protocol, this.username, this.password, this.host, this.port, this.path, this.getParameters());
    }

    public String getUsername() {
        return this.username;
    }

    public URL setUsername(String username) {
        return new URL(this.protocol, username, this.password, this.host, this.port, this.path, this.getParameters());
    }

    public String getPassword() {
        return this.password;
    }

    public URL setPassword(String password) {
        return new URL(this.protocol, this.username, password, this.host, this.port, this.path, this.getParameters());
    }

    public String getHost() {
        return this.host;
    }

    public URL setHost(String host) {
        return new URL(this.protocol, this.username, this.password, host, this.port, this.path, this.getParameters());
    }

    public int getPort() {
        return this.port;
    }

    public URL setPort(int port) {
        return new URL(this.protocol, this.username, this.password, this.host, port, this.path, this.getParameters());
    }

    public String getAddress() {
        return this.port <= 0 ? this.host : this.host + ":" + this.port;
    }

    public URL setAddress(String address) {
        String host;
        int i = address.lastIndexOf(58);
        int port = this.port;
        if (i >= 0) {
            host = address.substring(0, i);
            port = Integer.parseInt(address.substring(i + 1));
        } else {
            host = address;
        }
        return new URL(this.protocol, this.username, this.password, host, port, this.path, this.getParameters());
    }

    public String getPath() {
        return this.path;
    }

    public URL setPath(String path) {
        return new URL(this.protocol, this.username, this.password, this.host, this.port, path, this.getParameters());
    }

    public String getAbsolutePath() {
        if (this.path != null && !this.path.startsWith("/")) {
            return "/" + this.path;
        }
        return this.path;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getString(String key, boolean decode) {
        return this.getString(key, null, decode);
    }

    public String getString(String key, String defaultValue, boolean decode) {
        String value = this.getString(key, defaultValue);
        if (decode) {
            return URL.decode(value);
        }
        return value;
    }

    public String getString(String key) {
        return this.parameters.get(key);
    }

    public String getString(String key, String defaultValue) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return value;
    }

    public Date getDate(String key, Date defaultValue) {
        Long value = this.getLong(key, null);
        if (value == null) {
            return defaultValue;
        }
        return new Date(value);
    }

    public Date getDate(String key, SimpleDateFormat format, Date defaultValue) {
        String value = this.getString(key);
        if (value == null || value.isEmpty() || format == null) {
            return defaultValue;
        }
        try {
            return format.parse(key);
        }
        catch (ParseException e) {
            return defaultValue;
        }
    }

    public Float getDouble(String key, Float defaultValue) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Float.valueOf(Float.parseFloat(value));
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Double getDouble(String key, Double defaultValue) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Long getLong(String key, Long defaultValue) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Integer getInteger(String key, Integer defaultValue) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Short getShort(String key, Short defaultValue) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Byte getByte(String key, Byte defaultValue) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public Boolean getBoolean(String key, Boolean defaultValue) {
        String value = this.getString(key);
        if (value == null || value.isEmpty()) {
            return defaultValue;
        }
        return Boolean.parseBoolean(value);
    }

    public Long getNatrual(String key, Long defaultValue) {
        if (defaultValue != null && defaultValue < 0L) {
            throw new IllegalArgumentException("defaultValue < 0");
        }
        Long value = this.getLong(key, defaultValue);
        if (value != null && value < 0L) {
            return defaultValue;
        }
        return value;
    }

    public Integer getNatrual(String key, Integer defaultValue) {
        if (defaultValue != null && defaultValue < 0) {
            throw new IllegalArgumentException("defaultValue < 0");
        }
        Integer value = this.getInteger(key, defaultValue);
        if (value != null && value < 0) {
            return defaultValue;
        }
        return value;
    }

    public Short getNatrual(String key, Short defaultValue) {
        if (defaultValue != null && defaultValue < 0) {
            throw new IllegalArgumentException("defaultValue < 0");
        }
        Short value = this.getShort(key, defaultValue);
        if (value != null && value < 0) {
            return defaultValue;
        }
        return value;
    }

    public Byte getNatrual(String key, Byte defaultValue) {
        if (defaultValue != null && defaultValue < 0) {
            throw new IllegalArgumentException("defaultValue < 0");
        }
        Byte value = this.getByte(key, defaultValue);
        if (value != null && value < 0) {
            return defaultValue;
        }
        return value;
    }

    public Long getPositive(String key, Long defaultValue) {
        if (defaultValue != null && defaultValue <= 0L) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        Long value = this.getLong(key, defaultValue);
        if (value != null && value <= 0L) {
            return defaultValue;
        }
        return value;
    }

    public Integer getPositive(String key, Integer defaultValue) {
        if (defaultValue != null && defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        Integer value = this.getInteger(key, defaultValue);
        if (value != null && value <= 0) {
            return defaultValue;
        }
        return value;
    }

    public Short getPositive(String key, Short defaultValue) {
        if (defaultValue != null && defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        Short value = this.getShort(key, defaultValue);
        if (value != null && value <= 0) {
            return defaultValue;
        }
        return value;
    }

    public Byte getPositive(String key, Byte defaultValue) {
        if (defaultValue != null && defaultValue <= 0) {
            throw new IllegalArgumentException("defaultValue <= 0");
        }
        Byte value = this.getByte(key, defaultValue);
        if (value != null && value <= 0) {
            return defaultValue;
        }
        return value;
    }

    public boolean hasParameter(String key) {
        String value = this.getString(key);
        return value != null && !value.isEmpty();
    }

    public URL add(String key, boolean value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, char value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, byte value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, short value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, int value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, long value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, float value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, double value) {
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, Number value) {
        if (value == null) {
            return this;
        }
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, CharSequence value) {
        if (value == null || value.length() == 0) {
            return this;
        }
        return this.add(key, String.valueOf(value));
    }

    public URL add(String key, String value) {
        if (key == null || key.isEmpty() || value == null || value.isEmpty()) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.put(key, value);
        return new URL(this.protocol, this.username, this.password, this.host, this.port, this.path, map);
    }

    public URL add(String key, String value, boolean encode) {
        if (!encode) {
            return this.add(key, value);
        }
        return this.add(key, URL.encode(value));
    }

    public URL addIfAbsent(String key, String value) {
        if (key == null || key.isEmpty() || value == null || value.isEmpty()) {
            return this;
        }
        if (this.hasParameter(key)) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.put(key, value);
        return new URL(this.protocol, this.username, this.password, this.host, this.port, this.path, map);
    }

    public URL add(Map<String, String> parameters) {
        if (parameters == null || parameters.isEmpty()) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(this.getParameters());
        map.putAll(parameters);
        return new URL(this.protocol, this.username, this.password, this.host, this.port, this.path, map);
    }

    public URL addIfAbsent(Map<String, String> parameters) {
        if (parameters == null || parameters.size() == 0) {
            return this;
        }
        HashMap<String, String> map = new HashMap<String, String>(parameters);
        map.putAll(this.getParameters());
        return new URL(this.protocol, this.username, this.password, this.host, this.port, this.path, map);
    }

    public URL remove(String key) {
        if (key == null || key.isEmpty()) {
            return this;
        }
        return this.remove(key);
    }

    public URL remove(Collection<String> keys) {
        if (keys == null || keys.size() == 0) {
            return this;
        }
        return this.remove(keys.toArray(new String[keys.size()]));
    }

    public URL remove(String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        Map<String, String> parameters = this.getParameters();
        HashMap<String, String> map = new HashMap<String, String>(parameters);
        for (String key : keys) {
            map.remove(key);
        }
        if (map.size() == parameters.size()) {
            return this;
        }
        return new URL(this.protocol, this.username, this.password, this.host, this.port, this.path, map);
    }

    public URL remove() {
        return new URL(this.protocol, this.username, this.password, this.host, this.port, this.path, new HashMap<String, String>());
    }

    public String toString() {
        return this.toString(false, true, new String[0]);
    }

    public String toString(boolean user, boolean parameter, String ... parameters) {
        StringBuilder buf = new StringBuilder();
        if (this.protocol != null && !this.protocol.isEmpty()) {
            buf.append(this.protocol).append("://");
        }
        if (user && this.username != null && !this.username.isEmpty()) {
            buf.append(this.username);
            if (this.password != null && !this.password.isEmpty()) {
                buf.append(':').append(this.password);
            }
            buf.append('@');
        }
        if (this.host != null && !this.host.isEmpty()) {
            buf.append(this.host);
            if (this.port > 0) {
                buf.append(':').append(this.port);
            }
        }
        if (this.path != null && !this.path.isEmpty()) {
            if (this.path.charAt(0) != '/') {
                buf.append('/');
            }
            buf.append(this.path);
        }
        if (parameter) {
            this.appand(buf, true, parameters);
        }
        return buf.toString();
    }

    public String toParameter(boolean concat, String[] parameters) {
        StringBuilder buf = new StringBuilder();
        this.appand(buf, concat, parameters);
        return buf.toString();
    }

    private void appand(StringBuilder buf, boolean concat, String[] parameters) {
        Map<String, String> map = this.getParameters();
        if (map != null && !map.isEmpty()) {
            HashSet<String> includes = parameters == null || parameters.length == 0 ? null : new HashSet<String>(Arrays.asList(parameters));
            boolean first = true;
            for (Map.Entry<String, String> entry : new TreeMap<String, String>(map).entrySet()) {
                String key = entry.getKey();
                if (key == null || key.length() <= 0 || includes != null && !includes.contains(key)) continue;
                if (first) {
                    if (concat) {
                        buf.append('?');
                    }
                    first = false;
                } else {
                    buf.append('&');
                }
                buf.append(key).append('=');
                if (entry.getValue() == null) continue;
                buf.append(entry.getValue().trim());
            }
        }
    }

    public InetSocketAddress toInetSocketAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.host == null ? 0 : this.host.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + this.port;
        result = 31 * result + (this.protocol == null ? 0 : this.protocol.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        URL other = (URL)obj;
        if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.protocol == null) {
            return other.protocol == null;
        }
        return this.protocol.equals(other.protocol);
    }
}

