/*
 * Decompiled with CFR 0.152.
 */
package org.joyqueue.toolkit.concurrent;

import org.joyqueue.toolkit.os.Systems;
import sun.misc.Unsafe;

public class CAtomicLong {
    private static final Unsafe UNSAFE = Systems.getUnsafe();
    private static final long VALUE_OFFSET;
    protected long p1;
    protected long p2;
    protected long p3;
    protected long p4;
    protected long p5;
    protected long p6;
    protected long p7;
    protected volatile long value;
    protected long p9;
    protected long p10;
    protected long p11;
    protected long p12;
    protected long p13;
    protected long p14;
    protected long p15;

    public CAtomicLong() {
        this(-1L);
    }

    public CAtomicLong(long value) {
        UNSAFE.putOrderedLong(this, VALUE_OFFSET, value);
    }

    public long get() {
        return this.value;
    }

    public void set(long value) {
        UNSAFE.putOrderedLong(this, VALUE_OFFSET, value);
    }

    public void setVolatile(long value) {
        UNSAFE.putLongVolatile(this, VALUE_OFFSET, value);
    }

    public boolean compareAndSet(long expect, long position) {
        return UNSAFE.compareAndSwapLong(this, VALUE_OFFSET, expect, position);
    }

    public long incrementAndGet() {
        return this.addAndGet(1L);
    }

    public long addAndGet(long increment) {
        long target;
        long current;
        while (!this.compareAndSet(current = this.get(), target = current + increment)) {
        }
        return target;
    }

    static {
        try {
            VALUE_OFFSET = UNSAFE.objectFieldOffset(CAtomicLong.class.getDeclaredField("value"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

